/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Stack;

public class LocalFileResolver
implements ConfigurationFileResolver {
    private Stack configurationPathStack = new Stack();
    int version = CLIENT;
    public static int CLIENT = 0;
    public static int SERVER = 1;
    public static int LIVECYCLE = 2;

    public LocalFileResolver() {
    }

    public LocalFileResolver(int version) {
        this.version = version;
    }

    public void setErrorMessage(ConfigurationException e, String path) {
        if (this.version == LIVECYCLE) {
            e.setMessage(11122, new Object[]{path});
        } else if (this.version == SERVER) {
            e.setMessage(11108);
        } else {
            e.setMessage(11106);
        }
    }

    public InputStream getConfigurationFile(String path) {
        File f = new File(path);
        try {
            if (f != null && f.exists() && f.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f);
                this.pushConfigurationFile(f.getParent());
                return fin;
            }
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            throw e;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            e.setRootCause(ex);
            throw e;
        }
        catch (SecurityException se) {
            ConfigurationException e = new ConfigurationException();
            this.setErrorMessage(e, path);
            e.setRootCause(se);
            throw e;
        }
    }

    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f = new File(path);
        try {
            if (f != null && f.exists() && f.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f);
                this.pushConfigurationFile(f.getParent());
                return fin;
            }
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            throw e;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            e.setRootCause(ex);
            throw e;
        }
        catch (SecurityException se) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11107, new Object[]{path});
            e.setRootCause(se);
            throw e;
        }
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    private void pushConfigurationFile(String topLevelPath) {
        this.configurationPathStack.push(topLevelPath);
    }

    public String getIncludedPath(String src) {
        return this.configurationPathStack.peek() + File.separator + src;
    }

    public long getIncludedLastModified(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f = new File(path);
        return f.lastModified();
    }
}

