/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DroolsMismatchedSetException;
import org.drools.lang.DroolsMismatchedTokenException;
import org.drools.lang.DroolsParaphraseTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsParserExceptionFactory {
    public static final String MISMATCHED_TOKEN_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched input '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TOKEN_MESSAGE_PART = "Line %1$d:%2$d mismatched input '%3$s'%4$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched tree node '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_PART = "Line %1$d:%2$d mismatched tree node '%3$s'%4$s";
    public static final String NO_VIABLE_ALT_MESSAGE = "Line %1$d:%2$d no viable alternative at input '%3$s'%4$s";
    public static final String EARLY_EXIT_MESSAGE = "Line %1$d:%2$d required (...)+ loop did not match anything at input '%3$s'%4$s";
    public static final String MISMATCHED_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$s' expecting one of the following tokens: '%4$s'%5$s.";
    public static final String MISMATCHED_NOT_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$s' not expecting any of the following tokens: '%4$s'%5$s";
    public static final String FAILED_PREDICATE_MESSAGE = "Line %1$d:%2$d rule '%3$s' failed predicate: {%4$s}?%5$s";
    public static final String TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE = "Line %1$d:%2$d trailing semi-colon not allowed%3$s";
    public static final String PARSER_LOCATION_MESSAGE_COMPLETE = " in %1$s %2$s";
    public static final String PARSER_LOCATION_MESSAGE_PART = " in %1$s";
    public static final String UNEXPECTED_EXCEPTION = "Line %1$d:%2$d unexpected exception at input '%3$s'. Exception: %4$s. Stack trace:\n %5$s";
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = null;
    private String[] tokenNames = null;

    public DroolsParserExceptionFactory(Stack<Map<DroolsParaphraseTypes, String>> paraphrases) {
        this.paraphrases = paraphrases;
    }

    public DroolsParserException createTrailingSemicolonException(int line, int column, int offset) {
        String message = String.format(TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE, line, column, this.formatParserLocation());
        return new DroolsParserException("ERR 104", message, line, column, offset, null);
    }

    public DroolsParserException createDroolsException(RecognitionException e) {
        List<String> codeAndMessage = this.createErrorMessage(e);
        return new DroolsParserException(codeAndMessage.get(1), codeAndMessage.get(0), e.line, e.charPositionInLine, e.index, e);
    }

    private List<String> createErrorMessage(RecognitionException e) {
        ArrayList<String> codeAndMessage = new ArrayList<String>(2);
        String message = "";
        if (e instanceof MismatchedTokenException) {
            String expecting;
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String string = expecting = mte instanceof DroolsMismatchedTokenException ? ((DroolsMismatchedTokenException)mte).getTokenText() : this.getBetterToken(mte.expecting);
            if (this.tokenNames != null && mte.expecting >= 0 && mte.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expecting, this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            } else {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            }
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            if (mtne.expecting >= 0 && mtne.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.getBetterToken(mtne.expecting), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            } else {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            }
        } else if (e instanceof NoViableAltException) {
            message = String.format(NO_VIABLE_ALT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 101");
        } else if (e instanceof EarlyExitException) {
            message = String.format(EARLY_EXIT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 105");
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            String expected = this.expectedTokensAsString(mse.expecting);
            message = String.format(MISMATCHED_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expected, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 107");
        } else if (e instanceof DroolsMismatchedSetException) {
            DroolsMismatchedSetException mse = (DroolsMismatchedSetException)e;
            String expected = Arrays.asList(mse.getTokenText()).toString();
            message = String.format(MISMATCHED_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expected, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 107");
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            String expected = this.expectedTokensAsString(mse.expecting);
            message = String.format(MISMATCHED_NOT_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expected, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 108");
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            message = String.format(FAILED_PREDICATE_MESSAGE, e.line, e.charPositionInLine, fpe.ruleName, fpe.predicateText, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 103");
        }
        if (((String)codeAndMessage.get(0)).length() == 0) {
            codeAndMessage.add("?????");
        }
        return codeAndMessage;
    }

    public DroolsParserException createDroolsException(Exception e, Token token) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return new DroolsParserException(String.format(UNEXPECTED_EXCEPTION, token.getLine(), token.getCharPositionInLine(), this.getBetterToken(token), e.toString(), sw.toString()), e);
    }

    private String expectedTokensAsString(BitSet set) {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        int i = 0;
        for (int token : set.toArray()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getBetterToken(token));
            ++i;
        }
        buf.append(" }");
        String expected = buf.toString();
        return expected;
    }

    private String formatParserLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.paraphrases != null) {
            for (Map map : this.paraphrases) {
                for (Map.Entry activeEntry : map.entrySet()) {
                    if (((String)activeEntry.getValue()).length() == 0) {
                        String kStr = this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey()));
                        if (kStr.length() <= 0) continue;
                        sb.append(String.format(PARSER_LOCATION_MESSAGE_PART, kStr));
                        continue;
                    }
                    sb.append(String.format(PARSER_LOCATION_MESSAGE_COMPLETE, this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey())), activeEntry.getValue()));
                }
            }
        }
        return sb.toString();
    }

    private String getLocationName(DroolsParaphraseTypes type) {
        switch (type) {
            case PACKAGE: {
                return "package";
            }
            case IMPORT: {
                return "import";
            }
            case FUNCTION_IMPORT: {
                return "function import";
            }
            case GLOBAL: {
                return "global";
            }
            case FUNCTION: {
                return "function";
            }
            case QUERY: {
                return "query";
            }
            case TEMPLATE: {
                return "template";
            }
            case RULE: {
                return "rule";
            }
            case RULE_ATTRIBUTE: {
                return "rule attribute";
            }
            case PATTERN: {
                return "pattern";
            }
            case EVAL: {
                return "eval";
            }
        }
        return "";
    }

    private String getBetterToken(Token token) {
        if (token == null) {
            return "";
        }
        return this.getBetterToken(token.getType(), token.getText());
    }

    private String getBetterToken(int tokenType) {
        return this.getBetterToken(tokenType, null);
    }

    private String getBetterToken(int tokenType, String defaultValue) {
        switch (tokenType) {
            case 12: {
                return defaultValue == null ? "int" : defaultValue;
            }
            case 8: {
                return defaultValue == null ? "float" : defaultValue;
            }
            case 14: {
                return defaultValue == null ? "string" : defaultValue;
            }
            case 18: {
                return defaultValue == null ? "boolean" : defaultValue;
            }
            case 19: {
                return "null";
            }
            case 33: {
                return ";";
            }
            case 34: {
                return ":";
            }
            case 35: {
                return "==";
            }
            case 36: {
                return "!=";
            }
            case 39: {
                return ">";
            }
            case 37: {
                return ">=";
            }
            case 40: {
                return "<";
            }
            case 38: {
                return "<=";
            }
            case 32: {
                return "->";
            }
            case 67: {
                return defaultValue == null ? "identifier" : defaultValue;
            }
            case 42: {
                return "(";
            }
            case 43: {
                return ")";
            }
            case 44: {
                return "[";
            }
            case 45: {
                return "]";
            }
            case 46: {
                return "{";
            }
            case 47: {
                return "}";
            }
            case 48: {
                return ",";
            }
            case 49: {
                return ".";
            }
            case 50: {
                return "&&";
            }
            case 51: {
                return "||";
            }
            case 69: {
                return defaultValue == null ? "misc" : defaultValue;
            }
            case -1: {
                return "<eof>";
            }
        }
        return defaultValue;
    }
}

