/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.XMLChar;

public class PathFormat {
    private static final Pattern PATH_ELEMENT_PATTERN = Pattern.compile("(\\.)|(\\.\\.)|(([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?):)?([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?)(\\[([1-9]\\d*)\\])?");
    private static final ThreadLocal PATH_ELEMENT_MATCHER = new ThreadLocal(){

        protected Object initialValue() {
            return PATH_ELEMENT_PATTERN.matcher("dummy");
        }
    };

    public static Path parse(String jcrPath, NamespaceResolver resolver) throws MalformedPathException {
        return PathFormat.parse(null, jcrPath, resolver);
    }

    public static Path parse(Path parent, String jcrPath, NamespaceResolver resolver) throws MalformedPathException {
        if ("/".equals(jcrPath)) {
            return Path.ROOT;
        }
        String[] elems = Text.explode(jcrPath, 47, true);
        if (elems.length == 0) {
            throw new MalformedPathException("empty path");
        }
        Path.PathBuilder pathBuilder = parent != null ? new Path.PathBuilder(parent) : new Path.PathBuilder();
        for (int i = 0; i < elems.length; ++i) {
            String elem = elems[i];
            if (i == 0 && elem.length() == 0) {
                if (parent != null) {
                    throw new MalformedPathException("'" + jcrPath + "' is not a relative path");
                }
                pathBuilder.addLast(Path.ROOT_ELEMENT);
                continue;
            }
            if (elem.length() == 0 && i == elems.length - 1) break;
            Matcher matcher = (Matcher)PATH_ELEMENT_MATCHER.get();
            matcher.reset(elem);
            if (matcher.matches()) {
                String nsURI;
                String prefix;
                if (resolver == null) continue;
                if (matcher.group(1) != null) {
                    pathBuilder.addLast(Path.CURRENT_ELEMENT);
                    continue;
                }
                if (matcher.group(2) != null) {
                    pathBuilder.addLast(Path.PARENT_ELEMENT);
                    continue;
                }
                if (matcher.group(3) != null) {
                    prefix = matcher.group(4);
                    if (!XMLChar.isValidNCName(prefix)) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' specifies an illegal namespace prefix");
                    }
                } else {
                    prefix = "";
                }
                String localName = matcher.group(5);
                int index = matcher.group(6) != null ? Integer.parseInt(matcher.group(7)) : 0;
                try {
                    nsURI = resolver.getURI(prefix);
                }
                catch (NamespaceException nse) {
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' specifies an unmapped namespace prefix");
                }
                if (index == 0) {
                    pathBuilder.addLast(new QName(nsURI, localName));
                    continue;
                }
                pathBuilder.addLast(new QName(nsURI, localName), index);
                continue;
            }
            throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' is not a legal path element");
        }
        if (resolver != null) {
            return pathBuilder.getPath();
        }
        return null;
    }

    public static void checkFormat(String jcrPath) throws MalformedPathException {
        PathFormat.parse(null, jcrPath, null);
    }

    public static String format(Path path, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        if (path.denotesRoot()) {
            return "/";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.getLength(); ++i) {
            if (i > 0) {
                sb.append('/');
            }
            PathFormat.format(path.getElement(i), resolver, sb);
        }
        return sb.toString();
    }

    private static void format(Path.PathElement element, NamespaceResolver resolver, StringBuffer buf) throws NoPrefixDeclaredException {
        NameFormat.format(element.getName(), resolver, buf);
        int index = element.getIndex();
        if (index > 1) {
            buf.append('[');
            buf.append(index);
            buf.append(']');
        }
    }
}

