/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.HashMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;

public class ViewDemo
implements MembershipListener {
    private Channel channel;

    public void viewAccepted(View new_view) {
        System.out.println("** New view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
        System.out.println("Suspected(" + suspected_mbr + ')');
    }

    public void block() {
    }

    public void start(String props, boolean use_additional_data) throws Exception {
        this.channel = new JChannel(props);
        this.channel.setOpt(5, Boolean.TRUE);
        if (use_additional_data) {
            HashMap<String, byte[]> m = new HashMap<String, byte[]>();
            m.put("additional_data", "bela".getBytes());
            this.channel.down(new Event(56, m));
        }
        this.channel.connect("ViewDemo");
        new PullPushAdapter((Transport)this.channel, this);
        while (true) {
            Util.sleep(10000L);
        }
    }

    public static void main(String[] args) {
        ViewDemo t = new ViewDemo();
        boolean use_additional_data = false;
        String props = "UDP(mcast_addr=228.5.5.5;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                ViewDemo.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-use_additional_data".equals(args[i])) {
                use_additional_data = new Boolean(args[++i]);
                continue;
            }
            ViewDemo.help();
            return;
        }
        try {
            t.start(props, use_additional_data);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("ViewDemo [-props <properties>] [-help] [-use_additional_data <flag>]");
    }
}

