/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;

public abstract class BasicTCP
extends TP {
    boolean skip_suspected_members = true;
    boolean suspect_on_send_failure = false;
    final BoundedList suspected_mbrs = new BoundedList(20);
    protected InetAddress external_addr = null;
    protected int start_port = 7800;
    protected int end_port = 0;
    protected long reaper_interval = 0L;
    protected long conn_expire_time = 0L;
    boolean use_send_queues = true;
    int recv_buf_size = 150000;
    int send_buf_size = 150000;
    int sock_conn_timeout = 2000;
    boolean tcp_nodelay = false;
    int linger = -1;

    public int getStartPort() {
        return this.start_port;
    }

    public void setStartPort(int start_port) {
        this.start_port = start_port;
    }

    public int getEndPort() {
        return this.end_port;
    }

    public void setEndPort(int end_port) {
        this.end_port = end_port;
    }

    public long getReaperInterval() {
        return this.reaper_interval;
    }

    public void setReaperInterval(long reaper_interval) {
        this.reaper_interval = reaper_interval;
    }

    public long getConnExpireTime() {
        return this.conn_expire_time;
    }

    public void setConnExpireTime(long conn_expire_time) {
        this.conn_expire_time = conn_expire_time;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("start_port");
        if (str != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("end_port")) != null) {
            this.end_port = Integer.parseInt(str);
            props.remove("end_port");
        }
        if ((str = props.getProperty("external_addr")) != null) {
            try {
                this.external_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(external_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("external_addr");
        }
        if ((str = props.getProperty("reaper_interval")) != null) {
            this.reaper_interval = Long.parseLong(str);
            props.remove("reaper_interval");
        }
        if ((str = props.getProperty("conn_expire_time")) != null) {
            this.conn_expire_time = Long.parseLong(str);
            props.remove("conn_expire_time");
        }
        if ((str = props.getProperty("sock_conn_timeout")) != null) {
            this.sock_conn_timeout = Integer.parseInt(str);
            props.remove("sock_conn_timeout");
        }
        if ((str = props.getProperty("recv_buf_size")) != null) {
            this.recv_buf_size = Integer.parseInt(str);
            props.remove("recv_buf_size");
        }
        if ((str = props.getProperty("send_buf_size")) != null) {
            this.send_buf_size = Integer.parseInt(str);
            props.remove("send_buf_size");
        }
        if ((str = props.getProperty("skip_suspected_members")) != null) {
            this.skip_suspected_members = Boolean.valueOf(str);
            props.remove("skip_suspected_members");
        }
        if ((str = props.getProperty("suspect_on_send_failure")) != null) {
            this.suspect_on_send_failure = Boolean.valueOf(str);
            props.remove("suspect_on_send_failure");
        }
        if ((str = props.getProperty("use_send_queues")) != null) {
            this.use_send_queues = Boolean.valueOf(str);
            props.remove("use_send_queues");
        }
        if ((str = props.getProperty("tcp_nodelay")) != null) {
            this.tcp_nodelay = new Boolean(str);
            props.remove("tcp_nodelay");
        }
        if ((str = props.getProperty("linger")) != null) {
            this.linger = Integer.parseInt(str);
            props.remove("linger");
        }
        return true;
    }

    public void init() throws Exception {
        super.init();
        if (this.start_port <= 0) {
            Protocol dynamic_discovery_prot = this.stack.findProtocol("MPING");
            if (dynamic_discovery_prot == null) {
                dynamic_discovery_prot = this.stack.findProtocol("TCPGOSSIP");
            }
            if (dynamic_discovery_prot != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("dynamic discovery is present (" + dynamic_discovery_prot + "), so start_port=" + this.start_port + " is okay"));
                }
            } else {
                throw new IllegalArgumentException("start_port cannot be set to " + this.start_port + ", as no dynamic discovery protocol (e.g. MPING or TCPGOSSIP) has been detected.");
            }
        }
    }

    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        Vector mbrs = (Vector)this.members.clone();
        for (int i = 0; i < mbrs.size(); ++i) {
            Address dest = (Address)mbrs.elementAt(i);
            this.sendToSingleMember(dest, data, offset, length);
        }
    }

    public void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        block6: {
            if (this.trace) {
                this.log.trace((Object)("dest=" + dest + " (" + data.length + " bytes)"));
            }
            if (this.skip_suspected_members && this.suspected_mbrs.contains(dest)) {
                if (this.trace) {
                    this.log.trace((Object)("will not send unicast message to " + dest + " as it is currently suspected"));
                }
                return;
            }
            try {
                this.send(dest, data, offset, length);
            }
            catch (Exception e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failure sending message to " + dest), (Throwable)e);
                }
                if (!this.suspect_on_send_failure || !this.members.contains(dest) || this.suspected_mbrs.contains(dest)) break block6;
                this.suspected_mbrs.add(dest);
                this.passUp(new Event(9, dest));
            }
        }
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("connections: ").append(this.printConnections()).append("\n");
        return sb.toString();
    }

    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
        if (multicast) {
            msg.setDest(null);
        } else {
            msg.setDest(dest);
        }
    }

    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
        this.postUnmarshalling(msg, dest, null, multicast);
    }

    public abstract String printConnections();

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract void retainAll(Collection var1);

    public void receive(Address sender, byte[] data, int offset, int length) {
        this.receive(this.local_addr, sender, data, offset, length);
    }

    protected void handleDownEvent(Event evt) {
        super.handleDownEvent(evt);
        if (evt.getType() == 6) {
            Vector tmp_mbrs;
            this.suspected_mbrs.removeAll();
            View v = (View)evt.getArg();
            Vector vector = tmp_mbrs = v != null ? v.getMembers() : null;
            if (tmp_mbrs != null) {
                this.retainAll(tmp_mbrs);
            }
        } else if (evt.getType() == 51) {
            this.suspected_mbrs.removeElement(evt.getArg());
        }
    }
}

