/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.util.Rsp;

public class RspList
implements Map {
    final Map rsps = new HashMap();

    public RspList() {
    }

    public RspList(Collection responses) {
        if (responses != null) {
            Iterator it = responses.iterator();
            while (it.hasNext()) {
                Rsp rsp = (Rsp)it.next();
                this.rsps.put(rsp.getSender(), rsp);
            }
        }
    }

    public boolean isEmpty() {
        return this.rsps.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.rsps.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.rsps.containsValue(value);
    }

    public Object get(Object key) {
        return this.rsps.get(key);
    }

    public Object getValue(Object key) {
        Rsp rsp = (Rsp)this.get(key);
        return rsp != null ? rsp.getValue() : null;
    }

    public Object put(Object key, Object value) {
        return this.rsps.put(key, value);
    }

    public Object remove(Object key) {
        return this.rsps.remove(key);
    }

    public void putAll(Map m) {
        this.rsps.putAll(m);
    }

    public void clear() {
        this.rsps.clear();
    }

    public Set keySet() {
        return this.rsps.keySet();
    }

    public Collection values() {
        return this.rsps.values();
    }

    public Set entrySet() {
        return this.rsps.entrySet();
    }

    public void reset() {
        this.clear();
    }

    public void addRsp(Address sender, Object retval) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = retval;
            rsp.received = true;
            rsp.suspected = false;
            return;
        }
        this.rsps.put(sender, new Rsp(sender, retval));
    }

    public void addNotReceived(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp == null) {
            this.rsps.put(sender, new Rsp(sender));
        }
    }

    public void addSuspect(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = null;
            rsp.received = false;
            rsp.suspected = true;
            return;
        }
        this.rsps.put(sender, new Rsp(sender, true));
    }

    public boolean isReceived(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.received;
    }

    public int numSuspectedMembers() {
        int num = 0;
        Collection values = this.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Rsp rsp = (Rsp)it.next();
            if (!rsp.wasSuspected()) continue;
            ++num;
        }
        return num;
    }

    public Object getFirst() {
        Collection values = this.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Rsp rsp = (Rsp)it.next();
            if (rsp.getValue() == null) continue;
            return rsp.getValue();
        }
        return null;
    }

    public Vector getResults() {
        Vector<Object> ret = new Vector<Object>();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            Object val;
            Rsp rsp = (Rsp)it.next();
            if (!rsp.wasReceived() || (val = rsp.getValue()) == null) continue;
            ret.addElement(val);
        }
        return ret;
    }

    public Vector getSuspectedMembers() {
        Vector<Address> retval = new Vector<Address>();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            Rsp rsp = (Rsp)it.next();
            if (!rsp.wasSuspected()) continue;
            retval.addElement(rsp.getSender());
        }
        return retval;
    }

    public boolean isSuspected(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.suspected;
    }

    public int size() {
        return this.rsps.size();
    }

    public Object elementAt(int i) throws ArrayIndexOutOfBoundsException {
        TreeSet keys = new TreeSet(this.keySet());
        if (keys == null) {
            return null;
        }
        Object[] keys_array = keys.toArray();
        Object key = keys_array[i];
        return this.get(key);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            Rsp rsp = (Rsp)it.next();
            ret.append("[" + rsp + "]\n");
        }
        return ret.toString();
    }

    boolean contains(Address sender) {
        return this.containsKey(sender);
    }
}

