/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.definition.type.FactField;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.Trait;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitTripleProxyClassBuilderImpl
implements TraitProxyClassBuilder {
    private ClassDefinition trait;

    protected ClassDefinition getTrait() {
        return this.trait;
    }

    @Override
    public void init(ClassDefinition trait) {
        this.trait = trait;
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(0);
        long mask = TraitRegistry.getInstance().getFieldMask(this.getTrait().getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.getTrait(), core);
        String masterName = TraitFactory.getProxyName(this.getTrait(), core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String descrWrapper = BuildUtils.getTypeDescriptor(name);
        String descrProxy = BuildUtils.getTypeDescriptor(masterName);
        String internalCore = BuildUtils.getInternalType(core.getClassName());
        String descrCore = BuildUtils.getTypeDescriptor(core.getClassName());
        String internalTrait = BuildUtils.getInternalType(this.getTrait().getClassName());
        String descrTrait = BuildUtils.getTypeDescriptor(this.getTrait().getClassName());
        Class mixinClass = null;
        String mixin = null;
        HashSet<Method> mixinMethods = new HashSet<Method>();
        HashMap<String, Method> mixinGetSet = new HashMap<String, Method>();
        try {
            Trait annTrait;
            if (this.getTrait().getDefinedClass() != null && (annTrait = this.getAnnotation(this.getTrait().getDefinedClass(), Trait.class)) != null && !annTrait.impl().equals(Trait.NullMixin.class)) {
                mixinClass = annTrait.impl();
                mixin = mixinClass.getSimpleName().substring(0, 1).toLowerCase() + mixinClass.getSimpleName().substring(1);
                ClassFieldInspector cfi = new ClassFieldInspector(mixinClass);
                for (Method m : mixinClass.getMethods()) {
                    try {
                        this.getTrait().getDefinedClass().getMethod(m.getName(), m.getParameterTypes());
                        if (cfi.getGetterMethods().containsValue(m) || cfi.getSetterMethods().containsValue(m)) {
                            mixinGetSet.put(m.getName(), m);
                            continue;
                        }
                        mixinMethods.add(m);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cw.visit(49, 33, internalProxy, null, "org/drools/factmodel/traits/TraitProxy", new String[]{internalTrait, "java/io/Externalizable"});
        FieldVisitor fv = cw.visitField(145, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(130, "store", "Lorg/drools/core/util/TripleStore;", null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "storeId", "Ljava/lang/String;", null, null);
        fv.visitEnd();
        if (mixinClass != null) {
            fv = cw.visitField(2, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()), null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + descrCore + "Lorg/drools/core/util/TripleStore;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/drools/core/util/TripleStore", "getId", "()Ljava/lang/String;");
        mv.visitFieldInsn(181, internalProxy, "storeId", "Ljava/lang/String;");
        this.buildConstructorCore(cw, mv, internalProxy, internalWrapper, internalCore, descrCore, mixin, mixinClass);
        mv.visitInsn(177);
        mv.visitMaxs(5, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCore", "()" + descrCore + "", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getObject", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setObject", "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getCore", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getCore", "()" + descrCore + "");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "writeExternal", "(Ljava/io/ObjectOutput;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getObject", "()Ljava/lang/Object;");
        mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "storeId", "Ljava/lang/String;");
        mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "writeExternal", "(Ljava/io/ObjectOutput;)V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(Ljava/io/ObjectInput;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitFieldInsn(181, internalProxy, "storeId", "Ljava/lang/String;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "storeId", "Ljava/lang/String;");
        mv.visitMethodInsn(184, "org/drools/factmodel/traits/TripleStoreRegistry", "getRegistry", "(Ljava/lang/String;)Lorg/drools/core/util/TripleStore;");
        mv.visitFieldInsn(181, internalProxy, "store", "Lorg/drools/core/util/TripleStore;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "readExternal", "(Ljava/io/ObjectInput;)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitMethodInsn(185, "org/drools/factmodel/traits/TraitableBean", "getTraitMap", "()Ljava/util/Map;");
        mv.visitLdcInsn((Object)this.getTrait().getClassName());
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        this.buildProxyAccessors(mask, cw, masterName, core, mixinGetSet);
        boolean hasKeys = false;
        for (FactField ff : this.getTrait().getFields()) {
            if (!ff.isKey()) continue;
            hasKeys = true;
            break;
        }
        if (!hasKeys) {
            this.buildEqualityMethods((ClassVisitor)cw, masterName, core.getClassName());
        } else {
            this.buildKeyedEqualityMethods((ClassVisitor)cw, this.getTrait(), masterName, core.getClassName());
        }
        if (mixinClass != null) {
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinMethods);
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinGetSet.values());
        }
        this.buildCommonMethods(cw, masterName);
        this.buildExtendedMethods(cw, this.getTrait(), core);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private <K extends Annotation> K getAnnotation(Class klass, Class<K> annotationClass) {
        K ann = klass.getAnnotation(annotationClass);
        if (ann == null) {
            for (Class<?> sup : klass.getInterfaces()) {
                ann = this.getAnnotation(sup, annotationClass);
                if (ann == null) continue;
                return ann;
            }
            return null;
        }
        return ann;
    }

    protected void buildConstructorCore(ClassWriter cw, MethodVisitor mv, String internalProxy, String internalWrapper, String internalCore, String descrCore, String mixin, Class mixinClass) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "<init>", "()V");
        if (mixinClass != null) {
            try {
                Class actualArg = this.getPossibleConstructor(mixinClass, this.trait.getDefinedClass());
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, BuildUtils.getInternalType(mixinClass.getName()));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, BuildUtils.getInternalType(mixinClass.getName()), "<init>", "(" + BuildUtils.getTypeDescriptor(actualArg.getName()) + ")V");
                mv.visitFieldInsn(181, internalProxy, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            }
            catch (NoSuchMethodException nsme) {
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, BuildUtils.getInternalType(mixinClass.getName()));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, BuildUtils.getInternalType(mixinClass.getName()), "<init>", "()V");
                mv.visitFieldInsn(181, internalProxy, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalProxy, "store", "Lorg/drools/core/util/TripleStore;");
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, internalWrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, internalWrapper, "<init>", "(" + descrCore + "Lorg/drools/core/util/TripleStore;)V");
        mv.visitFieldInsn(181, internalProxy, "fields", "Ljava/util/Map;");
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, "org/drools/factmodel/traits/TripleBasedBean");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedBean", "<init>", "(Ljava/lang/Object;Lorg/drools/core/util/TripleStore;)V");
        mv.visitMethodInsn(182, internalCore, "setDynamicProperties", "(Ljava/util/Map;)V");
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, "org/drools/factmodel/traits/TripleBasedTypes");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TripleBasedTypes", "<init>", "(Ljava/lang/Object;Lorg/drools/core/util/TripleStore;)V");
        mv.visitMethodInsn(182, internalCore, "setTraitMap", "(Ljava/util/Map;)V");
    }

    private Class getPossibleConstructor(Class klass, Class arg) throws NoSuchMethodException {
        Constructor<?>[] ctors;
        for (Constructor<?> c : ctors = klass.getConstructors()) {
            Class<?>[] cpars = c.getParameterTypes();
            if (cpars.length != 1 || !cpars[0].isAssignableFrom(arg)) continue;
            return cpars[0];
        }
        throw new NoSuchMethodException("Constructor for " + klass + " using " + arg + " not found ");
    }

    protected void buildProxyAccessors(long mask, ClassWriter cw, String masterName, ClassDefinition core, Map<String, Method> mixinGetSet) {
        int j = 0;
        for (FieldDefinition field : this.getTrait().getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            this.buildProxyAccessor(mask, cw, masterName, core, mixinGetSet, field, isSoftField);
        }
    }

    protected void buildProxyAccessor(long mask, ClassWriter cw, String masterName, ClassDefinition core, Map<String, Method> mixinGetSet, FieldDefinition field, boolean isSoftField) {
        if (isSoftField) {
            if (!mixinGetSet.containsKey(BuildUtils.getterName(field.getName(), field.getTypeName()))) {
                this.buildSoftGetter((ClassVisitor)cw, field, masterName);
                this.buildSoftSetter((ClassVisitor)cw, field, masterName);
            }
        } else {
            FieldVisitor fv = cw.visitField(9, field.getName() + "_reader", "Lorg/drools/spi/InternalReadAccessor;", null, null);
            fv.visitEnd();
            fv = cw.visitField(9, field.getName() + "_writer", "Lorg/drools/spi/WriteAccessor;", null, null);
            fv.visitEnd();
            this.buildHardGetter((ClassVisitor)cw, field, masterName, this.getTrait(), core);
            this.buildHardSetter((ClassVisitor)cw, field, masterName, this.getTrait(), core);
        }
    }

    private void buildMixinMethods(ClassWriter cw, String wrapperName, String mixin, Class mixinClass, Collection<Method> mixinMethods) {
        for (Method method : mixinMethods) {
            String signature = TraitFactory.buildSignature(method);
            MethodVisitor mv = cw.visitMethod(1, method.getName(), signature, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapperName), mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()));
            int j = 1;
            for (Class<?> arg : method.getParameterTypes()) {
                mv.visitVarInsn(BuildUtils.varType(arg.getName()), j++);
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType(mixinClass.getName()), method.getName(), signature);
            mv.visitInsn(BuildUtils.returnType(method.getReturnType().getName()));
            int stack = TraitFactory.getStackSize(method);
            mv.visitMaxs(stack, stack);
            mv.visitEnd();
        }
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core) {
        this.buildHardGetter(cw, field, masterName, proxy, core, BuildUtils.getterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core, String getterName, boolean protect) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, getterName, "()" + BuildUtils.getTypeDescriptor(fieldType), null, null);
        mv.visitCode();
        TraitFactory.invokeExtractor(mv, masterName, proxy, core, field);
        if (!BuildUtils.isPrimitive(fieldType)) {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(fieldType));
        }
        mv.visitInsn(BuildUtils.returnType(fieldType));
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    protected void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core) {
        this.buildHardSetter(cw, field, masterName, trait, core, BuildUtils.setterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core, String setterName, boolean protect) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, setterName, "(" + BuildUtils.getTypeDescriptor(fieldType) + ")V", null, null);
        mv.visitCode();
        TraitFactory.invokeInjector(mv, masterName, trait, core, field, false, 1);
        mv.visitInsn(177);
        mv.visitMaxs(2 + BuildUtils.sizeOf(fieldType), 1 + BuildUtils.sizeOf(fieldType));
        mv.visitEnd();
    }

    protected void buildSoftSetter(ClassVisitor cw, FieldDefinition field, String proxy) {
        this.buildSoftSetter(cw, field, proxy, BuildUtils.setterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildSoftSetter(ClassVisitor cw, FieldDefinition field, String proxy, String setterName, boolean protect) {
        String fieldName = field.getName();
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, setterName, "(" + BuildUtils.getTypeDescriptor(type) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", "Lorg/drools/core/util/TripleStore;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(BuildUtils.varType(type), 1);
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.valueOf(mv, type);
        }
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "property", "(Ljava/lang/String;Ljava/lang/Object;)Lorg/drools/core/util/TripleImpl;");
        mv.visitMethodInsn(182, "org/drools/core/util/TripleStore", "put", "(Lorg/drools/core/util/Triple;)Z");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(3 + BuildUtils.sizeOf(type), 1 + BuildUtils.sizeOf(type));
        mv.visitEnd();
    }

    protected void buildSoftGetter(ClassVisitor cw, FieldDefinition field, String proxy) {
        this.buildSoftGetter(cw, field, proxy, BuildUtils.getterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildSoftGetter(ClassVisitor cw, FieldDefinition field, String proxy, String getterName, boolean protect) {
        String fieldName = field.getName();
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, getterName, "()" + BuildUtils.getTypeDescriptor(type), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", "Lorg/drools/core/util/TripleStore;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)fieldName);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "propertyKey", "(Ljava/lang/String;)Lorg/drools/core/util/TripleImpl;");
        mv.visitMethodInsn(182, "org/drools/core/util/TripleStore", "get", "(Lorg/drools/core/util/Triple;)Lorg/drools/core/util/Triple;");
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/drools/core/util/Triple", "getValue", "()Ljava/lang/Object;");
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitLabel(l0);
        mv.visitInsn(BuildUtils.zero(type));
        mv.visitInsn(BuildUtils.returnType(type));
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "org/drools/core/util/Triple", "getValue", "()Ljava/lang/Object;");
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.promote(mv, type);
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(type));
        }
        mv.visitInsn(BuildUtils.returnType(type));
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    public void buildEqualityMethods(ClassVisitor cw, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        String coreType = BuildUtils.getTypeDescriptor(core);
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "org/drools/factmodel/traits/TraitProxy");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()Ljava/util/Map;");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/drools/factmodel/traits/TraitProxy", "getFields", "()Ljava/util/Map;");
        mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getObject", "()Ljava/lang/Object;");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/drools/factmodel/traits/TraitProxy", "getObject", "()Ljava/lang/Object;");
        mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        Label l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/drools/factmodel/traits/TraitProxy", "hashCode", "()I");
        mv.visitVarInsn(54, 1);
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getObject", "()Ljava/lang/Object;");
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitInsn(96);
        mv.visitVarInsn(54, 1);
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()Ljava/util/Map;");
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitInsn(96);
        mv.visitVarInsn(54, 1);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitLdcInsn((Object)("(@" + proxy + ") : "));
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()Ljava/util/Map;");
        mv.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;");
        mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public void buildKeyedEqualityMethods(ClassVisitor cw, ClassDefinition trait, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        String coreType = BuildUtils.getTypeDescriptor(core);
        this.buildKeyedEquals(cw, trait, proxyType);
        this.buildKeyedHashCode(cw, trait, proxyType);
    }

    protected void buildKeyedEquals(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        Label l2 = new Label();
        mv.visitJumpInsn(165, l2);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, proxyType);
        mv.visitVarInsn(58, 2);
        int x = 2;
        int count = 0;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l11 = new Label();
                mv.visitJumpInsn(198, l11);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "equals", "(Ljava/lang/Object;)Z");
                Label l12 = new Label();
                mv.visitJumpInsn(154, l12);
                Label l13 = new Label();
                mv.visitJumpInsn(167, l13);
                mv.visitLabel(l11);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitJumpInsn(198, l12);
                mv.visitLabel(l13);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l12);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, "java/lang/Double", "compare", "(DD)I");
                Label l5 = new Label();
                mv.visitJumpInsn(153, l5);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l5);
                x = Math.max(x, 4);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, "java/lang/Float", "compare", "(FF)I");
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l6);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(148);
                Label l8 = new Label();
                mv.visitJumpInsn(153, l8);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l8);
                x = Math.max(x, 4);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            Label l4 = new Label();
            mv.visitJumpInsn(159, l4);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l4);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(x, 3);
        mv.visitEnd();
    }

    protected void buildKeyedHashCode(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(54, 1);
        int count = 0;
        int x = 2;
        int y = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l8 = new Label();
                mv.visitJumpInsn(198, l8);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "hashCode", "()I");
                Label l9 = new Label();
                mv.visitJumpInsn(167, l9);
                mv.visitLabel(l8);
                mv.visitInsn(3);
                mv.visitLabel(l9);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(14);
                mv.visitInsn(151);
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, "java/lang/Double", "doubleToLongBits", "(D)J");
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitInsn(9);
                mv.visitLabel(l3);
                mv.visitVarInsn(55, 2);
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(22, 2);
                mv.visitVarInsn(22, 2);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                y = Math.max(4, y);
                continue;
            }
            if ("boolean".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l4 = new Label();
                mv.visitJumpInsn(153, l4);
                mv.visitInsn(4);
                Label l5 = new Label();
                mv.visitJumpInsn(167, l5);
                mv.visitLabel(l4);
                mv.visitInsn(3);
                mv.visitLabel(l5);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(11);
                mv.visitInsn(149);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, "java/lang/Float", "floatToIntBits", "(F)I");
                Label l7 = new Label();
                mv.visitJumpInsn(167, l7);
                mv.visitLabel(l6);
                mv.visitInsn(3);
                mv.visitLabel(l7);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(3, x);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                continue;
            }
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(x, y);
        mv.visitEnd();
    }

    protected void buildCommonMethods(ClassWriter cw, String proxy) {
    }

    protected void buildExtendedMethods(ClassWriter cw, ClassDefinition trait, ClassDefinition core) {
    }
}

