/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.Restriction;

public abstract class AbstractCompositeRestriction
implements Restriction {
    private static final long serialVersionUID = 510L;
    protected Restriction[] restrictions;

    public AbstractCompositeRestriction() {
    }

    public AbstractCompositeRestriction(Restriction[] restriction) {
        this.restrictions = restriction;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.restrictions = (Restriction[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.restrictions);
    }

    public Declaration[] getRequiredDeclarations() {
        HashSet<Declaration> set = new HashSet<Declaration>();
        int ilength = this.restrictions.length;
        for (int i = 0; i < ilength; ++i) {
            Declaration[] declarations = this.restrictions[i].getRequiredDeclarations();
            int jlength = declarations.length;
            for (int j = 0; j < jlength; ++j) {
                if (declarations[j].getExtractor() == null) continue;
                set.add(declarations[j]);
            }
        }
        return set.toArray(new Declaration[set.size()]);
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.restrictions.length; ++i) {
            this.restrictions[i].replaceDeclaration(oldDecl, newDecl);
        }
    }

    public boolean isTemporal() {
        boolean temporal = false;
        for (Restriction r : this.restrictions) {
            if (!r.isTemporal()) continue;
            temporal = true;
            break;
        }
        return temporal;
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + AbstractCompositeRestriction.hashCode(this.restrictions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj instanceof AbstractCompositeRestriction) {
            return false;
        }
        AbstractCompositeRestriction other = (AbstractCompositeRestriction)obj;
        return Arrays.equals(this.restrictions, other.restrictions);
    }

    public ContextEntry createContextEntry() {
        return new CompositeContextEntry(this.restrictions);
    }

    public abstract Object clone();

    public static class CompositeContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public ContextEntry[] contextEntries;
        private ContextEntry entry;

        public CompositeContextEntry() {
        }

        public CompositeContextEntry(Restriction[] restrictions) {
            this.contextEntries = new ContextEntry[restrictions.length];
            for (int i = 0; i < restrictions.length; ++i) {
                this.contextEntries[i] = restrictions[i].createContextEntry();
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntries = (ContextEntry[])in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntries);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].updateFromFactHandle(workingMemory, handle);
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].updateFromTuple(workingMemory, tuple);
            }
        }

        public void resetTuple() {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].resetTuple();
            }
        }

        public void resetFactHandle() {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].resetFactHandle();
            }
        }
    }
}

