/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.AnnotationScanner;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassScanningAnnotationScanner
extends AnnotationScanner {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*");
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    private ClassFile classFileScanner = new ClassFile();

    public JavaClassScanningAnnotationScanner(ServletContext sc) {
        super(sc);
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> uris) {
        HashSet<String> classList = new HashSet<String>();
        this.processWebInfClasses(this.sc, classList);
        this.processClasspath(uris, classList);
        this.processScripts(classList);
        return this.processClassList(classList);
    }

    private void processClasspath(Set<URI> uris, Set<String> classList) {
        for (URI uri : uris) {
            try {
                Matcher m = JAR_PATTERN.matcher(uri.toString());
                if (m.matches()) {
                    String jarName = m.group(2);
                    if (!this.processJar(jarName)) continue;
                    StringBuilder sb = new StringBuilder(32);
                    String us = m.group(1);
                    if (!us.startsWith("jar:")) {
                        sb.append("jar:");
                    }
                    if (us.startsWith("zip:")) {
                        sb.append("file:").append(us.substring(4));
                    } else if (us.startsWith("bundle:")) {
                        sb.append("file:").append(us.substring(7));
                    } else {
                        sb.append(us);
                    }
                    sb.append("!/");
                    URL u = new URL(sb.toString());
                    JarFile jarFile = ((JarURLConnection)u.openConnection()).getJarFile();
                    this.processJarEntries(jarFile, this.getClasspathPackages() != null ? this.getClasspathPackages().get(jarName) : null, classList);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to match URL to a jar file: " + uri.toString());
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unable to process annotations for url, {0}.  Reason: " + e.toString(), new Object[]{uri});
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
    }

    private static boolean isAnnotation(String value) {
        return FACES_ANNOTATIONS.contains(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarEntries(JarFile jarFile, String[] allowedPackages, Set<String> classList) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Scanning JAR {0} for annotations...", jarFile.getName());
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String cname;
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith("META-INF") || !name.endsWith(".class") || !this.processClass(cname = this.convertToClassName(name), allowedPackages)) continue;
            ReadableByteChannel channel = null;
            try {
                channel = Channels.newChannel(jarFile.getInputStream(entry));
                if (!this.classFileScanner.containsAnnotation(channel)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[JAR] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unexpected exception scanning JAR {0} for annotations", jarFile.getName());
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                if (channel == null) continue;
                try {
                    channel.close();
                }
                catch (IOException ignored) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, ignored.toString(), ignored);
                }
            }
        }
    }

    private void processWebInfClasses(ServletContext sc, Set<String> classList) {
        this.processWebInfClasses(sc, WEB_INF_CLASSES, classList);
    }

    private void processWebInfClasses(ServletContext sc, String path, Set<String> classList) {
        Set paths = sc.getResourcePaths(path);
        this.processWebInfClasses(sc, paths, classList);
    }

    private void processWebInfClasses(ServletContext sc, Set<String> paths, Set<String> classList) {
        if (paths != null && !paths.isEmpty()) {
            for (String pathElement : paths) {
                String cname;
                if (pathElement.endsWith("/")) {
                    this.processWebInfClasses(sc, pathElement, classList);
                    continue;
                }
                if (!pathElement.endsWith(".class") || !this.processClass(cname = this.convertToClassName(WEB_INF_CLASSES, pathElement)) || !this.containsAnnotation(sc, pathElement)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/classes] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext sc, String pathElement) {
        Channel channel = null;
        try {
            URL url = sc.getResource(pathElement);
            channel = Channels.newChannel(url.openStream());
            boolean bl = this.classFileScanner.containsAnnotation((ReadableByteChannel)channel);
            return bl;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        finally {
            block19: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException ignored) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, ignored.toString(), ignored);
                    }
                }
            }
        }
        return false;
    }

    private String convertToClassName(String pathEntry) {
        return this.convertToClassName(null, pathEntry);
    }

    private String convertToClassName(String prefix, String pathEntry) {
        String className = pathEntry;
        if (prefix != null) {
            className = className.substring(prefix.length());
        }
        className = className.substring(0, className.length() - 6);
        return className.replace('/', '.');
    }

    private static class ConstantPoolInfo {
        private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
        public static final byte CLASS = 7;
        public static final int FIELDREF = 9;
        public static final int METHODREF = 10;
        public static final int STRING = 8;
        public static final int INTEGER = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int INTERFACEMETHODREF = 11;
        public static final int NAMEANDTYPE = 12;
        public static final int ASCIZ = 1;
        public static final int UNICODE = 2;
        byte[] bytes = new byte[Short.MAX_VALUE];

        public boolean containsAnnotation(int constantPoolSize, ByteBuffer buffer, ReadableByteChannel in) throws IOException {
            block7: for (int i = 1; i < constantPoolSize; ++i) {
                if (!this.refill(buffer, in, 1)) {
                    return true;
                }
                byte type = buffer.get();
                switch (type) {
                    case 1: 
                    case 2: {
                        String stringValue;
                        if (!this.refill(buffer, in, 2)) {
                            return true;
                        }
                        short length = buffer.getShort();
                        if (length < 0 || length > Short.MAX_VALUE) {
                            return true;
                        }
                        if (length > buffer.capacity()) {
                            return true;
                        }
                        if (!this.refill(buffer, in, length)) {
                            return true;
                        }
                        buffer.get(this.bytes, 0, length);
                        if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !JavaClassScanningAnnotationScanner.isAnnotation(stringValue = type == 1 ? new String(this.bytes, 0, (int)length, "US-ASCII") : new String(this.bytes, 0, (int)length))) continue block7;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        if (!this.refill(buffer, in, 2)) {
                            return true;
                        }
                        buffer.getShort();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (!this.refill(buffer, in, 4)) {
                            return true;
                        }
                        buffer.position(buffer.position() + 4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (!this.refill(buffer, in, 8)) {
                            return true;
                        }
                        buffer.position(buffer.position() + 8);
                        ++i;
                        continue block7;
                    }
                    case 12: {
                        if (!this.refill(buffer, in, 4)) {
                            return true;
                        }
                        buffer.getShort();
                        buffer.getShort();
                        continue block7;
                    }
                    default: {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue block7;
                        LOGGER.log(Level.SEVERE, "Unknow type constant pool {0} at position {1}", new Object[]{type, i});
                    }
                }
            }
            return false;
        }

        private boolean refill(ByteBuffer buffer, ReadableByteChannel in, int requestLen) throws IOException {
            int cap = buffer.capacity();
            if (buffer.position() + requestLen > cap) {
                buffer.compact();
                int read = in.read(buffer);
                if (read < 0) {
                    return false;
                }
                buffer.rewind();
            }
            return true;
        }
    }

    private static final class ClassFile {
        private static final int magic = -889275714;
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNCHRONIZED = 32;
        public static final int ACC_THREADSAFE = 64;
        public static final int ACC_TRANSIENT = 128;
        public static final int ACC_NATIVE = 256;
        public static final int ACC_INTERFACE = 512;
        public static final int ACC_ABSTRACT = 1024;
        public short majorVersion;
        public short minorVersion;
        public ConstantPoolInfo[] constantPool;
        public short accessFlags;
        public ConstantPoolInfo thisClass;
        public ConstantPoolInfo superClass;
        public ConstantPoolInfo[] interfaces;
        ByteBuffer header;
        ConstantPoolInfo constantPoolInfo = new ConstantPoolInfo();

        public ClassFile() {
            this.header = ByteBuffer.allocate(12000);
        }

        public void setConstantPoolInfo(ConstantPoolInfo poolInfo) {
            this.constantPoolInfo = poolInfo;
        }

        public boolean containsAnnotation(ReadableByteChannel in) throws IOException {
            this.header.clear();
            long read = in.read(this.header);
            if (read == -1L) {
                return false;
            }
            this.header.rewind();
            if (this.header.getInt() != -889275714) {
                return false;
            }
            this.minorVersion = this.header.getShort();
            this.majorVersion = this.header.getShort();
            short constantPoolSize = this.header.getShort();
            return this.constantPoolInfo.containsAnnotation(constantPoolSize, this.header, in);
        }
    }
}

