/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.protocol;

import java.util.Collection;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.DefaultProtocolDef;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.test.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.container.test.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.container.test.spi.client.protocol.Protocol;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolRegistryCreator {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ProtocolRegistry> registryInstance;

    public void createRegistry(@Observes ArquillianDescriptor event) throws Exception {
        Collection protocols = ((ServiceLoader)this.serviceLoader.get()).all(Protocol.class);
        Protocol<?> defaultProtocol = null;
        DefaultProtocolDef defaultProtcolDef = event.getDefaultProtocol();
        if (defaultProtcolDef != null && (defaultProtocol = this.findMatch(new ProtocolDescription(defaultProtcolDef.getType()), protocols)) == null) {
            throw new IllegalStateException("Defined default protocol " + defaultProtcolDef.getType() + " can not be found on classpath");
        }
        ProtocolRegistry registry = new ProtocolRegistry();
        for (Protocol protocol : protocols) {
            if (defaultProtocol != null && protocol.equals(defaultProtocol)) {
                registry.addProtocol(new ProtocolDefinition(protocol, defaultProtcolDef.getProperties(), true));
                continue;
            }
            registry.addProtocol(new ProtocolDefinition(protocol));
        }
        this.registryInstance.set((Object)registry);
    }

    private Protocol<?> findMatch(ProtocolDescription description, Collection<Protocol> protocols) {
        for (Protocol protocol : protocols) {
            if (!description.equals((Object)protocol.getDescription())) continue;
            return protocol;
        }
        return null;
    }
}

