/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.io.Serializable;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;
import org.hibernate.ejb.criteria.expression.function.FunctionExpression;

public class CastFunction<T, Y>
extends BasicFunctionExpression<T>
implements FunctionExpression<T>,
Serializable {
    public static final String CAST_NAME = "cast";
    private final ExpressionImpl<Y> castSource;

    public CastFunction(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, ExpressionImpl<Y> castSource) {
        super(criteriaBuilder, javaType, CAST_NAME);
        this.castSource = castSource;
    }

    public ExpressionImpl<Y> getCastSource() {
        return this.castSource;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getCastSource(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return "cast(" + this.castSource.render(renderingContext) + " as " + renderingContext.getCastType(this.getJavaType()) + ')';
    }
}

