/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIDownload;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;

/**
 * JSF Component for Link which is able to download a file
 **/
@Generated({"RichFaces CDK", "4.2.2.Final"})
public class HtmlDownload extends UIDownload
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.Download";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.Download";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlDownload() {
        super();
        setRendererType("org.jboss.seam.ui.DownloadRenderer");
    }




    protected enum Properties {
        accesskey,
        actionExpression,
        actionListener,
        conversationName,
        dir,
        disabled,
        fragment,
        image,
        immediate,
        includePageParams,
        lang,
        outcome,
        pageflow,
        propagation,
        rendered,
        src,
        style,
        styleClass,
        taskInstance,
        title,
        view
        
    }

 
    public String getAccesskey() {
        String value = (String) getStateHelper().eval(Properties.accesskey);
        return value;
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
        handleAttribute("accesskey",accesskey);
    }

 
    public MethodExpression getActionExpression() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.actionExpression);
        return value;
    }
    
    public void setActionExpression(MethodExpression actionExpression) {
        getStateHelper().put(Properties.actionExpression, actionExpression);
    }

 
    public MethodBinding getActionListener() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.actionListener);
        return value;
    }
    
    public void setActionListener(MethodBinding actionListener) {
        getStateHelper().put(Properties.actionListener, actionListener);
    }

 
    public String getConversationName() {
        String value = (String) getStateHelper().eval(Properties.conversationName);
        return value;
    }
    
    public void setConversationName(String conversationName) {
        getStateHelper().put(Properties.conversationName, conversationName);
    }

 
    public String getDir() {
        String value = (String) getStateHelper().eval(Properties.dir);
        return value;
    }
    
    public void setDir(String dir) {
        getStateHelper().put(Properties.dir, dir);
        handleAttribute("dir",dir);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public String getFragment() {
        String value = (String) getStateHelper().eval(Properties.fragment);
        return value;
    }
    
    public void setFragment(String fragment) {
        getStateHelper().put(Properties.fragment, fragment);
    }

 
    public String getImage() {
        String value = (String) getStateHelper().eval(Properties.image);
        return value;
    }
    
    public void setImage(String image) {
        getStateHelper().put(Properties.image, image);
    }

 
    public boolean isImmediate() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.immediate, Boolean.FALSE);
        return value;
    }
    
    public void setImmediate(boolean immediate) {
        getStateHelper().put(Properties.immediate, immediate);
    }

 
    public boolean isIncludePageParams() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.includePageParams, true);
        return value;
    }
    
    public void setIncludePageParams(boolean includePageParams) {
        getStateHelper().put(Properties.includePageParams, includePageParams);
    }

 
    public String getLang() {
        String value = (String) getStateHelper().eval(Properties.lang);
        return value;
    }
    
    public void setLang(String lang) {
        getStateHelper().put(Properties.lang, lang);
        handleAttribute("lang",lang);
    }

 
    public String getOutcome() {
        String value = (String) getStateHelper().eval(Properties.outcome);
        return value;
    }
    
    public void setOutcome(String outcome) {
        getStateHelper().put(Properties.outcome, outcome);
    }

 
    public String getPageflow() {
        String value = (String) getStateHelper().eval(Properties.pageflow);
        return value;
    }
    
    public void setPageflow(String pageflow) {
        getStateHelper().put(Properties.pageflow, pageflow);
    }

 
    public String getPropagation() {
        String value = (String) getStateHelper().eval(Properties.propagation, "default");
        return value;
    }
    
    public void setPropagation(String propagation) {
        getStateHelper().put(Properties.propagation, propagation);
    }

 
    public boolean isRendered() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.rendered, true);
        return value;
    }
    
    public void setRendered(boolean rendered) {
        getStateHelper().put(Properties.rendered, rendered);
    }

 
    public String getSrc() {
        String value = (String) getStateHelper().eval(Properties.src);
        return value;
    }
    
    public void setSrc(String src) {
        getStateHelper().put(Properties.src, src);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTaskInstance() {
        String value = (String) getStateHelper().eval(Properties.taskInstance);
        return value;
    }
    
    public void setTaskInstance(String taskInstance) {
        getStateHelper().put(Properties.taskInstance, taskInstance);
    }

 
    public String getTitle() {
        String value = (String) getStateHelper().eval(Properties.title);
        return value;
    }
    
    public void setTitle(String title) {
        getStateHelper().put(Properties.title, title);
        handleAttribute("title",title);
    }

 
    public String getView() {
        String value = (String) getStateHelper().eval(Properties.view);
        return value;
    }
    
    public void setView(String view) {
        getStateHelper().put(Properties.view, view);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(5);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}