/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import org.hibernate.Transaction;
import org.hibernate.event.EventSource;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.WeakIdentityHashMap;

public class TransactionalWorker
implements Worker {
    protected WeakIdentityHashMap synchronizationPerTransaction = new WeakIdentityHashMap();
    private QueueingProcessor queueingProcessor;

    public void performWork(Work work, EventSource session) {
        if (session.isTransactionInProgress()) {
            Transaction transaction = session.getTransaction();
            PostTransactionWorkQueueSynchronization txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transaction);
            if (txSync == null || txSync.isConsumed()) {
                txSync = new PostTransactionWorkQueueSynchronization(this.queueingProcessor, this.synchronizationPerTransaction);
                transaction.registerSynchronization(txSync);
                this.synchronizationPerTransaction.put(transaction, txSync);
            }
            txSync.add(work);
        } else {
            WorkQueue queue = new WorkQueue(2);
            this.queueingProcessor.add(work, queue);
            this.queueingProcessor.prepareWorks(queue);
            this.queueingProcessor.performWorks(queue);
        }
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactory) {
        this.queueingProcessor = new BatchedQueueingProcessor(searchFactory, props);
    }
}

