/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa.impl;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.impl.FullTextQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextEntityManagerImpl
implements FullTextEntityManager,
Serializable {
    private EntityManager em;
    private FullTextSession ftSession;

    public FullTextEntityManagerImpl(EntityManager em) {
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FullTextSession getFullTextSession() {
        if (this.ftSession != null) return this.ftSession;
        Object delegate = this.em.getDelegate();
        if (delegate == null) {
            throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager (no delegate)");
        }
        if (Session.class.isAssignableFrom(delegate.getClass())) {
            this.ftSession = Search.createFullTextSession((Session)delegate);
            return this.ftSession;
        } else {
            if (!EntityManager.class.isAssignableFrom(delegate.getClass())) throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager: " + delegate.getClass());
            if ((delegate = ((EntityManager)delegate).getDelegate()) == null) {
                throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager (no delegate)");
            }
            if (!Session.class.isAssignableFrom(delegate.getClass())) throw new SearchException("Trying to use Hibernate Search without an Hibernate EntityManager: " + delegate.getClass());
            this.ftSession = Search.createFullTextSession((Session)delegate);
        }
        return this.ftSession;
    }

    @Override
    public FullTextQuery createFullTextQuery(Query luceneQuery, Class ... entities) {
        FullTextSession ftSession = this.getFullTextSession();
        return new FullTextQueryImpl(ftSession.createFullTextQuery(luceneQuery, entities), ftSession);
    }

    @Override
    public void index(Object entity) {
        this.getFullTextSession().index(entity);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.getFullTextSession().getSearchFactory();
    }

    @Override
    public void purge(Class entityType, Serializable id) {
        this.getFullTextSession().purge(entityType, id);
    }

    @Override
    public void purgeAll(Class entityType) {
        this.getFullTextSession().purgeAll(entityType);
    }

    @Override
    public void persist(Object entity) {
        this.em.persist(entity);
    }

    @Override
    public <T> T merge(T entity) {
        return this.em.merge(entity);
    }

    @Override
    public void remove(Object entity) {
        this.em.remove(entity);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.em.find(entityClass, primaryKey);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return this.em.getReference(entityClass, primaryKey);
    }

    @Override
    public void flush() {
        this.em.flush();
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.em.setFlushMode(flushMode);
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.em.getFlushMode();
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        this.em.lock(entity, lockMode);
    }

    @Override
    public void refresh(Object entity) {
        this.em.refresh(entity);
    }

    @Override
    public void clear() {
        this.em.clear();
    }

    @Override
    public boolean contains(Object entity) {
        return this.em.contains(entity);
    }

    @Override
    public javax.persistence.Query createQuery(String ejbqlString) {
        return this.em.createQuery(ejbqlString);
    }

    @Override
    public javax.persistence.Query createNamedQuery(String name) {
        return this.em.createNamedQuery(name);
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString) {
        return this.em.createNativeQuery(sqlString);
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        return this.em.createNativeQuery(sqlString, resultClass);
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.em.createNativeQuery(sqlString, resultSetMapping);
    }

    @Override
    public void joinTransaction() {
        this.em.joinTransaction();
    }

    @Override
    public Object getDelegate() {
        return this.em.getDelegate();
    }

    @Override
    public void close() {
        this.em.close();
    }

    @Override
    public boolean isOpen() {
        return this.em.isOpen();
    }

    @Override
    public EntityTransaction getTransaction() {
        return this.em.getTransaction();
    }
}

