/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.ConstructionInfo;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedAdvisorDomain;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.MethodInterceptors;
import org.jboss.aop.MethodMatchInfo;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceSorter;
import org.jboss.aop.instrument.ConByConJoinPointGenerator;
import org.jboss.aop.instrument.ConByMethodJoinPointGenerator;
import org.jboss.aop.instrument.ConstructionJoinPointGenerator;
import org.jboss.aop.instrument.ConstructorJoinPointGenerator;
import org.jboss.aop.instrument.FieldJoinPointGenerator;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodByConJoinPointGenerator;
import org.jboss.aop.instrument.MethodByMethodJoinPointGenerator;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.pointcut.PointcutMethodMatch;
import org.jboss.aop.util.UnmodifiableEmptyCollections;

public class GeneratedClassAdvisor
extends ClassAdvisor {
    public static final String ADD_METHOD_INFO = "addMethodInfo";
    public static final String ADD_CONSTRUCTOR_INFO = "addConstructorInfo";
    public static final String ADD_CONSTRUCTION_INFO = "addConstructionInfo";
    public static final String ADD_FIELD_READ_INFO = "addFieldReadInfo";
    public static final String ADD_FIELD_WRITE_INFO = "addFieldWriteInfo";
    public static final String GET_PARENT_ADVISOR = "getParentAdvisor";
    MethodInterceptors methodInfos = new MethodInterceptors(this);
    ArrayList constructorInfos = new ArrayList();
    ArrayList constructionInfos = new ArrayList();
    ArrayList fieldReadInfos = new ArrayList();
    ArrayList fieldWriteInfos = new ArrayList();
    ArrayList overriddenMethods = new ArrayList();
    private volatile ConcurrentHashMap joinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    private volatile ConcurrentHashMap fieldReadJoinPoinGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    private volatile ConcurrentHashMap constructionJoinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap oldInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap oldFieldReadInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    ConcurrentHashMap oldConstructionInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    boolean initialisedSuperClasses;
    private int version;
    AdvisorStrategy advisorStrategy;
    ConcurrentHashMap perClassJoinpointAspectDefinitions = new ConcurrentHashMap();

    protected GeneratedClassAdvisor(String classname) {
        super(classname, null);
        this.advisorStrategy = new ClassAdvisorStrategy();
    }

    protected GeneratedClassAdvisor(String classname, GeneratedClassAdvisor parent) {
        super(classname, null);
        this.advisorStrategy = new InstanceAdvisorStrategy(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Map subscribedSubDomains;
        super.cleanup();
        this.methodInfos = null;
        this.advisorStrategy = null;
        Map map = subscribedSubDomains = this.getManager().getSubscribedSubDomains();
        synchronized (map) {
            Iterator it = subscribedSubDomains.keySet().iterator();
            while (it.hasNext()) {
                GeneratedAdvisorDomain manager = (GeneratedAdvisorDomain)it.next();
                Map advisors = manager.getAdvisors();
                it.remove();
            }
        }
    }

    protected void initialise(Class clazz, AspectManager manager) {
        this.advisorStrategy.initialise(clazz, manager);
    }

    protected void initialiseCallers() {
    }

    protected void initialiseInfosForInstance() {
    }

    protected MethodInfo copyInfoFromClassAdvisor(MethodInfo info) {
        MethodInfo copy = (MethodInfo)info.copy();
        copy.setAdvisor(this);
        this.addMethodInfo(copy);
        return copy;
    }

    protected FieldInfo copyInfoFromClassAdvisor(FieldInfo info) {
        FieldInfo copy = (FieldInfo)info.copy();
        copy.setAdvisor(this);
        if (copy.isRead()) {
            this.addFieldReadInfo(copy);
        } else {
            this.addFieldWriteInfo(copy);
        }
        return copy;
    }

    protected ConByConInfo copyInfoFromClassAdvisor(ConByConInfo info) {
        ConByConInfo copy = (ConByConInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected MethodByConInfo copyInfoFromClassAdvisor(MethodByConInfo info) {
        MethodByConInfo copy = (MethodByConInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected ConByMethodInfo copyInfoFromClassAdvisor(ConByMethodInfo info) {
        ConByMethodInfo copy = (ConByMethodInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected MethodByMethodInfo copyInfoFromClassAdvisor(MethodByMethodInfo info) {
        MethodByMethodInfo copy = (MethodByMethodInfo)info.copy();
        copy.setAdvisor(this);
        return copy;
    }

    protected void rebuildInterceptors() {
        ++this.version;
        this.advisorStrategy.rebuildInterceptors();
    }

    protected synchronized void internalRebuildInterceptors() {
        super.rebuildInterceptors();
    }

    protected void checkVersion() {
        this.advisorStrategy.checkVersion();
    }

    protected void doRebuildForInstance() {
    }

    protected void handleOverriddenMethods(AdviceBinding binding) {
        if (this.overriddenMethods != null && this.overriddenMethods.size() > 0) {
            for (MethodInfo info : this.overriddenMethods) {
                Method method = info.getMethod();
                PointcutMethodMatch match = binding.getPointcut().matchesExecution((Advisor)this, method);
                if (match == null || !match.isMatch()) continue;
                this.adviceBindings.add(binding);
                if (AspectManager.verbose) {
                    System.err.println("method matched binding " + binding.getPointcut().getExpr() + " " + method.toString());
                }
                binding.addAdvisor(this);
                this.pointcutResolved(info, binding, new MethodJoinpoint(method));
            }
        }
    }

    protected void resolveMethodPointcut(MethodInterceptors newMethodInterceptors, AdviceBinding binding) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor == null) {
            super.resolveMethodPointcut(newMethodInterceptors, binding);
            this.handleOverriddenMethods(binding);
        }
    }

    protected void resolveFieldPointcut(ArrayList newFieldInfos, AdviceBinding binding, boolean write) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor == null) {
            super.resolveFieldPointcut(newFieldInfos, binding, write);
        }
    }

    protected void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding) {
        this.advisorStrategy.resolveConstructorPointcut(newConstructorInfos, binding);
    }

    protected void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding) {
        this.advisorStrategy.resolveConstructionPointcut(newConstructionInfos, binding);
    }

    protected void initialiseMethods() {
    }

    protected void addMethodInfo(MethodInfo mi) {
        MethodInfo old = this.methodInfos.getMethodInfo(mi.getHash());
        if (old != null) {
            this.overriddenMethods.add(old);
        }
        this.methodInfos.put(mi.getHash(), mi);
        this.advisorStrategy.makeAccessibleMethod(mi);
    }

    protected MethodInterceptors initializeMethodChain() {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodMatchInfo matchInfo = this.methodInfos.getMatchInfo(keys[i]);
            if (this.initialized && matchInfo != null) {
                matchInfo.clear();
            }
            if (matchInfo != null) continue;
            MethodInfo info = new MethodInfo();
            Method amethod = (Method)this.advisedMethods.get(keys[i]);
            info.setAdvisedMethod(amethod);
            info.setUnadvisedMethod(amethod);
            info.setHash(keys[i]);
            info.setAdvisor(this);
            this.methodInfos.put(keys[i], info);
        }
        return this.methodInfos;
    }

    protected void initialiseConstructors() {
    }

    protected void addConstructorInfo(ConstructorInfo ci) {
        this.constructorInfos.add(ci);
        SecurityActions.setAccessible(ci.getConstructor());
    }

    protected void createInterceptorChains() throws Exception {
        this.advisorStrategy.createInterceptorChains();
    }

    protected ArrayList initializeConstructorChain() {
        if (this.initialized) {
            Iterator it = this.constructorInfos.iterator();
            while (it.hasNext()) {
                ((ConstructorInfo)it.next()).clear();
            }
        }
        return this.constructorInfos;
    }

    protected void initialiseConstructions() {
    }

    protected void addConstructionInfo(ConstructionInfo ci) {
        this.constructionInfos.add(ci);
    }

    protected ArrayList initializeConstructionChain() {
        if (this.initialized) {
            Iterator it = this.constructionInfos.iterator();
            while (it.hasNext()) {
                ((ConstructionInfo)it.next()).clear();
            }
        }
        return this.constructionInfos;
    }

    protected void initialiseFieldReads() {
    }

    protected void addFieldReadInfo(FieldInfo fi) {
        this.fieldReadInfos.add(fi);
        this.advisorStrategy.makeAccessibleField(fi);
    }

    protected ArrayList initializeFieldReadChain() {
        return this.mergeFieldInfos(this.fieldReadInfos, true);
    }

    protected void initialiseFieldWrites() {
    }

    protected void addFieldWriteInfo(FieldInfo fi) {
        this.fieldWriteInfos.add(fi);
        this.advisorStrategy.makeAccessibleField(fi);
    }

    protected ArrayList initializeFieldWriteChain() {
        return this.mergeFieldInfos(this.fieldWriteInfos, false);
    }

    private ArrayList mergeFieldInfos(ArrayList advisedInfos, boolean read) {
        ArrayList<FieldInfo> newInfos = new ArrayList<FieldInfo>(this.advisedFields.length);
        FieldInfo nextFieldInfo = null;
        Iterator it = advisedInfos.iterator();
        if (it.hasNext()) {
            nextFieldInfo = (FieldInfo)it.next();
        }
        for (int i = 0; i < this.advisedFields.length; ++i) {
            if (nextFieldInfo != null && nextFieldInfo.getIndex() == i) {
                if (this.initialized) {
                    nextFieldInfo.clear();
                }
                newInfos.add(nextFieldInfo);
                if (it.hasNext()) {
                    nextFieldInfo = (FieldInfo)it.next();
                    continue;
                }
                nextFieldInfo = null;
                continue;
            }
            FieldInfo info = new FieldInfo((Advisor)this, read);
            info.setAdvisedField(this.advisedFields[i]);
            info.setIndex(i);
            newInfos.add(info);
        }
        return newInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeChains(MethodInterceptors newMethodInfos, ArrayList newFieldReadInfos, ArrayList newFieldWriteInfos, ArrayList newConstructorInfos, ArrayList newConstructionInfos) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            HashSet hashSet = this.adviceBindings;
            synchronized (hashSet) {
                this.adviceBindings.addAll(classAdvisor.adviceBindings);
                for (AdviceBinding binding : this.adviceBindings) {
                    binding.addAdvisor(this);
                }
            }
        }
        super.finalizeChains(newMethodInfos, newFieldReadInfos, newFieldWriteInfos, newConstructorInfos, newConstructionInfos);
    }

    protected void finalizeMethodChain(MethodInterceptors newMethodInterceptors) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeMethodChainForInstance(classAdvisor, newMethodInterceptors);
        } else {
            this.fullWorkFinalizeMethodChain(newMethodInterceptors);
        }
    }

    private void easyFinalizeMethodChainForInstance(ClassAdvisor classAdvisor, MethodInterceptors newMethodInterceptors) {
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo classMethodInfo = classAdvisor.getMethodInfo(keys[i]);
            MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
            MethodInfo myMethodInfo = matchInfo.getInfo();
            myMethodInfo.cloneChains(classMethodInfo);
            if (!this.updateOldInfo(this.oldInfos, myMethodInfo, OldInfoMaps.INFOS)) continue;
            MethodJoinPointGenerator generator = this.getJoinPointGenerator(myMethodInfo);
            generator.rebindJoinpoint(myMethodInfo);
        }
    }

    private void fullWorkFinalizeMethodChain(MethodInterceptors newMethodInterceptors) {
        TLongObjectHashMap newMethodInfos = new TLongObjectHashMap();
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
            matchInfo.populateBindings();
            MethodInfo info = matchInfo.getInfo();
            newMethodInfos.put(keys[i], (Object)info);
            MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
            this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
        }
        this.methodInterceptors = newMethodInfos;
        if (this.overriddenMethods != null && this.overriddenMethods.size() > 0) {
            for (MethodInfo info : this.overriddenMethods) {
                MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
                this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
            }
        }
    }

    protected void finalizeFieldReadChain(ArrayList newFieldInfos) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeFieldChainForInstance(this.oldFieldReadInfos, classAdvisor.getFieldReadInfos(), newFieldInfos, OldInfoMaps.FIELD_READ_INFOS);
        } else {
            this.fullWorkFinalizeFieldChain(this.oldFieldReadInfos, newFieldInfos, OldInfoMaps.FIELD_READ_INFOS);
        }
    }

    protected void finalizeFieldWriteChain(ArrayList newFieldInfos) {
        GeneratedClassAdvisor classAdvisor = this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
        if (classAdvisor != null) {
            this.easyFinalizeFieldChainForInstance(this.oldInfos, classAdvisor.getFieldWriteInfos(), newFieldInfos, OldInfoMaps.INFOS);
        } else {
            this.fullWorkFinalizeFieldChain(this.oldInfos, newFieldInfos, OldInfoMaps.INFOS);
        }
    }

    private void easyFinalizeFieldChainForInstance(Map oldFieldInfos, FieldInfo[] classFieldInfos, ArrayList newFieldInfos, OldInfoMaps oldInfoMapInstance) {
        if (newFieldInfos.size() > 0) {
            for (int i = 0; i < newFieldInfos.size(); ++i) {
                FieldInfo myInfo = (FieldInfo)newFieldInfos.get(i);
                myInfo.cloneChains(classFieldInfos[i]);
                if (!this.updateOldInfo(oldFieldInfos, myInfo, oldInfoMapInstance)) continue;
                FieldJoinPointGenerator generator = this.getJoinPointGenerator(myInfo);
                generator.rebindJoinpoint(myInfo);
            }
        }
    }

    private void fullWorkFinalizeFieldChain(Map oldFieldInfos, ArrayList newFieldInfos, OldInfoMaps oldInfoMapInstance) {
        for (int i = 0; i < newFieldInfos.size(); ++i) {
            FieldInfo info = (FieldInfo)newFieldInfos.get(i);
            FieldJoinPointGenerator generator = this.getJoinPointGenerator(info);
            this.finalizeChainAndRebindJoinPoint(oldFieldInfos, info, generator, oldInfoMapInstance);
        }
    }

    protected void finalizeConstructorChain(ArrayList newConstructorInfos) {
        this.advisorStrategy.finalizeConstructorChain(newConstructorInfos);
    }

    protected void finalizeConstructionChain(ArrayList newConstructionInfos) {
        this.advisorStrategy.finalizeConstructionChain(newConstructionInfos);
    }

    protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info) {
        MethodByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info) {
        ConByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    protected void finalizeConCalledByConInterceptorChain(ConByConInfo info) {
        ConByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info) {
        ConcurrentHashMap map = (ConcurrentHashMap)this.joinPointGenerators.get(info.getJoinpoint());
        if (map == null) {
            map = new ConcurrentHashMap();
            this.initJoinPointGeneratorsMap();
            this.joinPointGenerators.put(info.getJoinpoint(), map);
            map = (ConcurrentHashMap)this.joinPointGenerators.get(info.getJoinpoint());
        }
        MethodByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        this.finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
    }

    private JoinPointGenerator getJoinPointGenerator(JoinPointInfo info) {
        if (info instanceof MethodInfo) {
            return this.getJoinPointGenerator((MethodInfo)info);
        }
        if (info instanceof FieldInfo) {
            return this.getJoinPointGenerator((FieldInfo)info);
        }
        if (info instanceof ConstructionInfo) {
            return this.getJoinPointGenerator((ConstructionInfo)info);
        }
        if (info instanceof ConstructorInfo) {
            return this.getJoinPointGenerator((ConstructorInfo)info);
        }
        if (info instanceof ConByConInfo) {
            return this.getJoinPointGenerator((ConByConInfo)info);
        }
        if (info instanceof ConByMethodInfo) {
            return this.getJoinPointGenerator((ConByMethodInfo)info);
        }
        if (info instanceof MethodByMethodInfo) {
            return this.getJoinPointGenerator((MethodByMethodInfo)info);
        }
        if (info instanceof MethodByConInfo) {
            return this.getJoinPointGenerator((MethodByConInfo)info);
        }
        throw new RuntimeException("Invalid JoinPointInfo passed in: " + info.getClass().getName());
    }

    protected MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
        return this.advisorStrategy.getJoinPointGenerator(info);
    }

    protected void pointcutResolved(JoinPointInfo info, AdviceBinding binding, Joinpoint joinpoint) {
        ArrayList curr = info.getInterceptorChain();
        if (binding.getCFlow() != null) {
            InterceptorFactory[] factories = binding.getInterceptorFactories();
            for (int i = 0; i < factories.length; ++i) {
                curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint, binding.getCFlowString(), binding.getCFlow()));
            }
        } else {
            InterceptorFactory[] factories = binding.getInterceptorFactories();
            for (int i = 0; i < factories.length; ++i) {
                curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint));
            }
        }
    }

    private void finalizeChainAndRebindJoinPoint(Map oldInfos, JoinPointInfo info, JoinPointGenerator generator, OldInfoMaps oldInfoMapInstance) {
        ArrayList list2 = info.getInterceptorChain();
        GeneratedAdvisorInterceptor[] factories = null;
        if (list2.size() > 0) {
            factories = this.applyPrecedence(list2.toArray(new GeneratedAdvisorInterceptor[list2.size()]));
        }
        info.setInterceptors(factories);
        if (this.updateOldInfo(oldInfos, info, oldInfoMapInstance)) {
            generator.rebindJoinpoint(info);
        }
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        StringBuffer sb = new StringBuffer("CLASS: " + clazz.getName());
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            sb.append("\n\t" + fields[i]);
        }
        return sb.toString();
    }

    GeneratedAdvisorInterceptor[] applyPrecedence(GeneratedAdvisorInterceptor[] interceptors) {
        return PrecedenceSorter.applyPrecedence(interceptors, this.manager);
    }

    public Object getPerClassAspect(AspectDefinition def) {
        return this.advisorStrategy.getPerClassAspect(def);
    }

    public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        return this.advisorStrategy.getPerClassJoinpointAspect(def, joinpoint);
    }

    public synchronized void addPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        ConcurrentHashMap<Joinpoint, Object> joinpoints = (ConcurrentHashMap<Joinpoint, Object>)this.perClassJoinpointAspectDefinitions.get(def);
        if (joinpoints == null) {
            joinpoints = new ConcurrentHashMap<Joinpoint, Object>();
            this.perClassJoinpointAspectDefinitions.put(def, joinpoints);
        }
        if (joinpoints.get(joinpoint) == null) {
            joinpoints.put(joinpoint, def.getFactory().createPerJoinpoint(this, joinpoint));
        }
        def.registerAdvisor(this);
    }

    public synchronized void removePerClassJoinpointAspect(AspectDefinition def) {
        this.perClassJoinpointAspectDefinitions.remove(def);
    }

    public boolean chainOverridingForInheritedMethods() {
        return true;
    }

    public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def) {
        Object instance = this.getPerClassJoinpointAspect(def, joinpoint);
        if (instance == null) {
            this.addPerClassJoinpointAspect(def, joinpoint);
            instance = this.getPerClassJoinpointAspect(def, joinpoint);
        }
        return instance;
    }

    private GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
        return this.advisorStrategy.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
    }

    protected void createMethodTables() throws Exception {
        this.advisorStrategy.createMethodTables();
    }

    protected void createFieldTable() throws Exception {
        this.advisorStrategy.createFieldTable();
    }

    protected void createConstructorTables() throws Exception {
        this.advisorStrategy.createConstructorTables();
    }

    public Set getPerInstanceAspectDefinitions() {
        return this.advisorStrategy.getPerInstanceAspectDefinitions();
    }

    public Map getPerInstanceJoinpointAspectDefinitions() {
        return this.advisorStrategy.getPerInstanceJoinpointAspectDefinitions();
    }

    private boolean updateOldInfo(Map oldInfos, JoinPointInfo newInfo, OldInfoMaps oldInfoMapInstance) {
        JoinPointInfo oldInfo = (JoinPointInfo)oldInfos.get(newInfo.getJoinpoint());
        if (oldInfo != null && oldInfo.equalChains(newInfo)) {
            return false;
        }
        oldInfo = newInfo.copy();
        if (oldInfoMapInstance == OldInfoMaps.INFOS) {
            oldInfos = this.initOldInfosMap();
        } else if (oldInfoMapInstance == OldInfoMaps.FIELD_READ_INFOS) {
            oldInfos = this.initOldFieldReadInfosMap();
        } else if (oldInfoMapInstance == OldInfoMaps.CONSTRUCTION_INFOS) {
            oldInfos = this.initOldConstructionInfosMap();
        } else {
            throw new RuntimeException("Unrecognised map");
        }
        oldInfos.put(newInfo.getJoinpoint(), oldInfo);
        return true;
    }

    protected void generateJoinPointClass(MethodInfo info) {
        MethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(FieldInfo info) {
        FieldJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConstructorInfo info) {
        ConstructorJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConstructionInfo info) {
        ConstructionJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(MethodByMethodInfo info) {
        MethodByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConByMethodInfo info) {
        ConByMethodJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(ConByConInfo info) {
        ConByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected void generateJoinPointClass(MethodByConInfo info) {
        MethodByConJoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    protected Object rebindJoinPointWithInstanceInformation(JoinPointInfo info) {
        JoinPointGenerator generator = this.getJoinPointGenerator(info);
        generator.rebindJoinpoint(info);
        return generator.generateJoinPointClass(this.getClass().getClassLoader(), info);
    }

    public Object createAndRebindJoinPointForInstance(JoinPointInfo info) {
        JoinPointInfo newinfo = info.copy();
        newinfo.setAdvisor(this);
        return this.rebindJoinPointWithInstanceInformation(newinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJoinPointGeneratorsMap() {
        if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.joinPointGenerators = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFieldReadJoinPointGeneratorsMap() {
        if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.fieldReadJoinPoinGenerators = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConstructionJoinPointGeneratorsMap() {
        if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.constructionJoinPointGenerators = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap initOldInfosMap() {
        if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldInfos = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
        return this.oldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap initOldFieldReadInfosMap() {
        if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldFieldReadInfos = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
        return this.oldFieldReadInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap initOldConstructionInfosMap() {
        if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            this.lockWrite();
            try {
                if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.oldConstructionInfos = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlockWrite();
            }
        }
        return this.oldConstructionInfos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OldInfoMaps {
        INFOS,
        FIELD_READ_INFOS,
        CONSTRUCTION_INFOS;

    }

    private class InstanceAdvisorStrategy
    implements AdvisorStrategy {
        GeneratedClassAdvisor parent;
        boolean needsRebuild = true;

        public InstanceAdvisorStrategy(GeneratedClassAdvisor parent) {
            this.parent = parent;
            GeneratedClassAdvisor.this.version = parent.version;
        }

        public void initialise(Class clazz, AspectManager manager) {
            GeneratedClassAdvisor.this.initialiseInfosForInstance();
            GeneratedClassAdvisor.super.setManager(manager);
            manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
        }

        public void checkVersion() {
            if (this.needsRebuild || this.parent.version != GeneratedClassAdvisor.this.version) {
                GeneratedClassAdvisor.this.doRebuildForInstance();
                this.needsRebuild = false;
            }
        }

        public void createInterceptorChains() throws Exception {
            if (GeneratedClassAdvisor.this.initialized) {
                GeneratedClassAdvisor.super.createInterceptorChains();
            } else {
                GeneratedClassAdvisor.this.initialized = true;
            }
        }

        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
            return this.parent.getJoinPointGenerator(info);
        }

        public Object getPerClassAspect(AspectDefinition def) {
            Object aspect = this.parent.getPerClassAspect(def);
            if (aspect != null) {
                return aspect;
            }
            return GeneratedClassAdvisor.super.getPerClassAspect(def);
        }

        public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
            Object aspect = this.parent.getPerClassJoinpointAspect(def, joinpoint);
            if (aspect != null) {
                return aspect;
            }
            return this.parent.getPerClassJoinpointAspect(def, joinpoint);
        }

        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
            if (((Domain)GeneratedClassAdvisor.this.getManager()).hasOwnDataWithEffectOnAdvices()) {
                return null;
            }
            return this.parent;
        }

        public void createMethodTables() throws Exception {
            GeneratedClassAdvisor.this.unadvisedMethods = this.parent.unadvisedMethods;
            GeneratedClassAdvisor.this.advisedMethods = this.parent.advisedMethods;
        }

        public void createFieldTable() throws Exception {
            GeneratedClassAdvisor.this.advisedFields = this.parent.advisedFields;
        }

        public void createConstructorTables() throws Exception {
            GeneratedClassAdvisor.this.constructors = this.parent.constructors;
            GeneratedClassAdvisor.this.methodCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.methodCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.conCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
            GeneratedClassAdvisor.this.conCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
        }

        public Set getPerInstanceAspectDefinitions() {
            return this.parent.getPerInstanceAspectDefinitions();
        }

        public Map getPerInstanceJoinpointAspectDefinitions() {
            return this.parent.getPerInstanceJoinpointAspectDefinitions();
        }

        public synchronized void rebuildInterceptors() {
            if (this.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() != null && GeneratedClassAdvisor.this.version != this.parent.version) {
                GeneratedClassAdvisor.this.adviceBindings.clear();
                this.needsRebuild = true;
            } else {
                GeneratedClassAdvisor.super.rebuildInterceptors();
            }
        }

        public void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding) {
        }

        public void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding) {
        }

        public void finalizeConstructorChain(ArrayList newConstructorInfos) {
        }

        public void finalizeConstructionChain(ArrayList newConstructionInfos) {
        }

        public void makeAccessibleField(FieldInfo fi) {
        }

        public void makeAccessibleMethod(MethodInfo mi) {
        }
    }

    private class ClassAdvisorStrategy
    implements AdvisorStrategy {
        GeneratedClassAdvisor parent;

        private ClassAdvisorStrategy() {
        }

        public void initialise(Class clazz, AspectManager manager) {
            GeneratedClassAdvisor.this.initialiseMethods();
            GeneratedClassAdvisor.this.initialiseConstructors();
            GeneratedClassAdvisor.this.initialiseConstructions();
            GeneratedClassAdvisor.this.initialiseFieldReads();
            GeneratedClassAdvisor.this.initialiseFieldWrites();
            GeneratedClassAdvisor.super.setManager(manager);
            Advisor existing = AspectManager.instance().getAnyAdvisorIfAdvised(clazz);
            if (existing != null) {
                GeneratedClassAdvisor.this.aspects = existing.aspects;
                if (existing instanceof GeneratedClassAdvisor) {
                    GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions = ((GeneratedClassAdvisor)existing).perClassJoinpointAspectDefinitions;
                }
            }
            manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
            GeneratedClassAdvisor.this.initialiseCallers();
        }

        public void checkVersion() {
        }

        public void createInterceptorChains() throws Exception {
            GeneratedClassAdvisor.super.createInterceptorChains();
        }

        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info) {
            MethodJoinPointGenerator generator = (MethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new MethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                MethodJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info) {
            if (info.isRead()) {
                FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.get(info.getJoinpoint());
                if (generator == null) {
                    generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
                    GeneratedClassAdvisor.this.initFieldReadJoinPointGeneratorsMap();
                    FieldJoinPointGenerator existing = GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.putIfAbsent(info.getJoinpoint(), generator);
                    if (existing != null) {
                        generator = existing;
                    }
                }
                return generator;
            }
            FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                FieldJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info) {
            ConstructorJoinPointGenerator generator = (ConstructorJoinPointGenerator)GeneratedClassAdvisor.this.constructionJoinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConstructorJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initConstructionJoinPointGeneratorsMap();
                ConstructorJoinPointGenerator existing = GeneratedClassAdvisor.this.constructionJoinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info) {
            ConstructionJoinPointGenerator generator = (ConstructionJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConstructionJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConstructionJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info) {
            MethodByMethodJoinPointGenerator generator;
            ConcurrentHashMap<Class, MethodByMethodJoinPointGenerator> map = (ConcurrentHashMap<Class, MethodByMethodJoinPointGenerator>)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (map == null) {
                map = new ConcurrentHashMap<Class, MethodByMethodJoinPointGenerator>();
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConcurrentHashMap existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
                if (existing != null) {
                    map = existing;
                }
            }
            if ((generator = (MethodByMethodJoinPointGenerator)map.get(info.getCalledClass())) == null) {
                generator = new MethodByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                MethodByMethodJoinPointGenerator existing = map.putIfAbsent(info.getCalledClass(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info) {
            ConByMethodJoinPointGenerator generator = (ConByMethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConByMethodJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info) {
            ConByConJoinPointGenerator generator = (ConByConJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (generator == null) {
                generator = new ConByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConByConJoinPointGenerator existing = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info) {
            MethodByConJoinPointGenerator generator;
            ConcurrentHashMap<Class, MethodByConJoinPointGenerator> map = (ConcurrentHashMap<Class, MethodByConJoinPointGenerator>)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
            if (map == null) {
                map = new ConcurrentHashMap<Class, MethodByConJoinPointGenerator>();
                GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
                ConcurrentHashMap exisiting = GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
                if (exisiting != null) {
                    map = exisiting;
                }
            }
            if ((generator = (MethodByConJoinPointGenerator)map.get(info.getCalledClass())) == null) {
                generator = new MethodByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
                MethodByConJoinPointGenerator existing = map.putIfAbsent(info.getCalledClass(), generator);
                if (existing != null) {
                    generator = existing;
                }
            }
            return generator;
        }

        public Object getPerClassAspect(AspectDefinition def) {
            return GeneratedClassAdvisor.super.getPerClassAspect(def);
        }

        public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
            Map joinpoints = (Map)GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions.get(def);
            if (joinpoints != null) {
                return joinpoints.get(joinpoint);
            }
            return null;
        }

        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() {
            return null;
        }

        public void createMethodTables() throws Exception {
            GeneratedClassAdvisor.super.createMethodTables();
        }

        public void createFieldTable() throws Exception {
            GeneratedClassAdvisor.super.createFieldTable();
        }

        public void createConstructorTables() throws Exception {
            GeneratedClassAdvisor.super.createConstructorTables();
        }

        public Set getPerInstanceAspectDefinitions() {
            return GeneratedClassAdvisor.super.getPerInstanceAspectDefinitions();
        }

        public Map getPerInstanceJoinpointAspectDefinitions() {
            return GeneratedClassAdvisor.super.getPerInstanceJoinpointAspectDefinitions();
        }

        public void rebuildInterceptors() {
            GeneratedClassAdvisor.this.version++;
            GeneratedClassAdvisor.super.rebuildInterceptors();
        }

        public void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding) {
            GeneratedClassAdvisor.super.resolveConstructorPointcut(newConstructorInfos, binding);
        }

        public void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding) {
            GeneratedClassAdvisor.super.resolveConstructionPointcut(newConstructionInfos, binding);
        }

        public void finalizeConstructorChain(ArrayList newConstructorInfos) {
            for (int i = 0; i < newConstructorInfos.size(); ++i) {
                ConstructorInfo info = (ConstructorInfo)newConstructorInfos.get(i);
                ConstructorJoinPointGenerator generator = this.getJoinPointGenerator(info);
                GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldInfos, info, generator, OldInfoMaps.INFOS);
            }
        }

        public void finalizeConstructionChain(ArrayList newConstructionInfos) {
            for (int i = 0; i < newConstructionInfos.size(); ++i) {
                ConstructionInfo info = (ConstructionInfo)newConstructionInfos.get(i);
                ConstructionJoinPointGenerator generator = this.getJoinPointGenerator(info);
                GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldConstructionInfos, info, generator, OldInfoMaps.CONSTRUCTION_INFOS);
            }
        }

        public void makeAccessibleField(FieldInfo fi) {
            SecurityActions.setAccessible(fi.getField());
        }

        public void makeAccessibleMethod(MethodInfo mi) {
            SecurityActions.setAccessible(mi.getMethod());
        }
    }

    private static interface AdvisorStrategy {
        public void initialise(Class var1, AspectManager var2);

        public void checkVersion();

        public void createInterceptorChains() throws Exception;

        public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo var1);

        public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo var1);

        public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo var1);

        public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo var1);

        public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo var1);

        public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo var1);

        public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo var1);

        public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo var1);

        public Object getPerClassAspect(AspectDefinition var1);

        public Object getPerClassJoinpointAspect(AspectDefinition var1, Joinpoint var2);

        public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();

        public void createMethodTables() throws Exception;

        public void createFieldTable() throws Exception;

        public void createConstructorTables() throws Exception;

        public Set getPerInstanceAspectDefinitions();

        public Map getPerInstanceJoinpointAspectDefinitions();

        public void rebuildInterceptors();

        public void resolveConstructorPointcut(ArrayList var1, AdviceBinding var2);

        public void resolveConstructionPointcut(ArrayList var1, AdviceBinding var2);

        public void finalizeConstructorChain(ArrayList var1);

        public void finalizeConstructionChain(ArrayList var1);

        public void makeAccessibleField(FieldInfo var1);

        public void makeAccessibleMethod(MethodInfo var1);
    }
}

