/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCallByConstructor;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;

public class MethodByConInfo
extends CallerMethodInfo
implements MethodCallByConstructor {
    private final int callingIndex;
    private final Constructor calling;

    public MethodByConInfo(Advisor advisor, Class calledClass, Class callingClass, int callingIndex, Method m, long calledMethodHash, Interceptor[] in) {
        super(advisor, calledClass, m, calledMethodHash, in, callingClass);
        this.callingIndex = callingIndex;
        Advisor tempAdvisor = advisor;
        if (advisor.getClazz() != callingClass) {
            tempAdvisor = advisor.manager.getAdvisor(callingClass);
        }
        this.calling = tempAdvisor.constructors[callingIndex];
    }

    private MethodByConInfo(MethodByConInfo other) {
        super(other);
        this.callingIndex = other.callingIndex;
        this.calling = other.calling;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new MethodCalledByConstructorJoinpoint(this.calling, this.getMethod());
    }

    public JoinPointInfo copy() {
        return new MethodByConInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method called by Constructor");
        sb.append("[");
        sb.append("calling=" + this.calling);
        sb.append(",called=" + this.getMethod());
        sb.append("]");
        return sb.toString();
    }

    public int getCallingIndex() {
        return this.callingIndex;
    }

    @Deprecated
    public Constructor getCalling() {
        return this.calling;
    }

    public Constructor getCallingConstructor() {
        return this.calling;
    }
}

