/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeAlgorithm {
    public static final short NOT_ASSIGNABLE_DEGREE = Short.MAX_VALUE;
    public static final short MAX_DEGREE = 32766;
    private static final DegreeAlgorithm INSTANCE = new DegreeAlgorithm();

    public static DegreeAlgorithm getInstance() {
        return INSTANCE;
    }

    private DegreeAlgorithm() {
    }

    public short getAssignabilityDegree(Type type, Type fromType) {
        if (type == null || fromType == null) {
            return 32766;
        }
        Class<?> clazz = this.getClassType(type);
        if (clazz == null) {
            return 32766;
        }
        Class<?> fromClass = this.getClassType(fromType);
        if (fromClass == null) {
            return 32766;
        }
        return this.getAssignabilityDegree(fromClass, clazz);
    }

    private Class<?> getClassType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return null;
        }
        Type componentType = ((GenericArrayType)type).getGenericComponentType();
        Class<?> componentClass = this.getClassType(componentType);
        try {
            return componentClass.getClassLoader().loadClass(componentClass.getName() + "[]");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private short getAssignabilityDegree(Class<?> fromType, Class<?> toType) {
        if (fromType == toType) {
            return 0;
        }
        if (toType.isInterface()) {
            if (fromType.isInterface()) {
                return this.getInterfaceInheritanceAD(fromType, toType, (short)0);
            }
            return this.getImplementationAD(fromType, toType);
        }
        if (fromType.isInterface()) {
            if (toType.getName() == "java.lang.Object") {
                ArrayList<Class<?>[]> list1 = new ArrayList<Class<?>[]>();
                ArrayList<Class<?>[]> list2 = new ArrayList<Class<?>[]>();
                Class<?>[] fromTypeInterfaces = fromType.getInterfaces();
                if (fromTypeInterfaces.length == 0) {
                    return 1;
                }
                list1.add(fromTypeInterfaces);
                short degree = 2;
                while (true) {
                    for (Class[] classArray : list1) {
                        for (int i = 0; i < classArray.length; ++i) {
                            Class<?>[] superInterfaces = classArray[i].getInterfaces();
                            if (superInterfaces.length == 0) {
                                return degree;
                            }
                            list2.add(superInterfaces);
                        }
                    }
                    degree = (short)(degree + 1);
                    list1.clear();
                    ArrayList<Class<?>[]> temp = list1;
                    list1 = list2;
                    list2 = temp;
                }
            }
            return Short.MAX_VALUE;
        }
        return this.getClassInheritanceAD(fromType.getSuperclass(), toType, (short)1);
    }

    private short getImplementationAD(Class<?> fromClassType, Class<?> toInterfaceType) {
        if (fromClassType == null) {
            return Short.MAX_VALUE;
        }
        Class<?>[] interfaces = fromClassType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != toInterfaceType) continue;
            return 1;
        }
        short currentDegree = Short.MAX_VALUE;
        for (int i = 0; i < interfaces.length; ++i) {
            currentDegree = (short)Math.min(this.getInterfaceInheritanceAD(interfaces[i], toInterfaceType, (short)1), currentDegree);
        }
        if (currentDegree == Short.MAX_VALUE) {
            return this.getImplementationAD(fromClassType.getSuperclass(), toInterfaceType);
        }
        return currentDegree;
    }

    private short getInterfaceInheritanceAD(Class<?> fromInterfaceType, Class<?> toInterfaceType, short currentDegree) {
        Class<?>[] interfaces = fromInterfaceType.getInterfaces();
        currentDegree = (short)(currentDegree + 1);
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != toInterfaceType) continue;
            return currentDegree;
        }
        short bestDegree = Short.MAX_VALUE;
        for (int i = 0; i < interfaces.length; ++i) {
            bestDegree = (short)Math.min(this.getInterfaceInheritanceAD(interfaces[i], toInterfaceType, currentDegree), bestDegree);
        }
        return bestDegree;
    }

    private short getClassInheritanceAD(Class<?> fromClassType, Class<?> toClassType, short currentDegree) {
        if (fromClassType == null) {
            return Short.MAX_VALUE;
        }
        if (fromClassType == toClassType) {
            return currentDegree;
        }
        currentDegree = (short)(currentDegree + 1);
        return this.getClassInheritanceAD(fromClassType.getSuperclass(), toClassType, currentDegree);
    }
}

