/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.aop.annotation.PortableAnnotationElement;

public class AnnotationElement
extends PortableAnnotationElement {
    public static Object getVisibleAnnotation(Method method, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(method, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(method, annotation);
    }

    public static Object getVisibleAnnotation(Constructor con, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(con, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(con, annotation);
    }

    public static Object getVisibleAnnotation(Field field, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(field, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(field, annotation);
    }

    public static Object getVisibleAnnotation(Class clazz, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(clazz, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(clazz, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Class clazz, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Method m, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Field f, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Constructor con, Class annotation) {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
        }
        return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
    }

    public static Object[] getVisibleAnnotations(Class clazz) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(clazz);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(clazz);
    }

    public static Object[] getVisibleAnnotations(Method m) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(m);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(m);
    }

    public static Object[] getVisibleAnnotations(Field f) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(f);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(f);
    }

    public static Object[] getVisibleAnnotations(Constructor c) throws Exception {
        if (System.getSecurityManager() == null) {
            return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(c);
        }
        return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(c);
    }

    private static interface AnnotationElementAction {
        public static final AnnotationElementAction NON_PRIVILEGED = new AnnotationElementAction(){

            public Object getVisibleAnnotation(Method method, Class annotation) {
                return method.getAnnotation(annotation);
            }

            public Object getVisibleAnnotation(Constructor con, Class annotation) {
                return con.getAnnotation(annotation);
            }

            public Object getVisibleAnnotation(Field field, Class annotation) {
                return field.getAnnotation(annotation);
            }

            public Object getVisibleAnnotation(Class clazz, Class annotation) {
                return clazz.getAnnotation(annotation);
            }

            public boolean isVisibleAnnotationPresent(Class clazz, Class annotation) {
                return clazz.isAnnotationPresent(annotation);
            }

            public boolean isVisibleAnnotationPresent(Method m, Class annotation) {
                return m.isAnnotationPresent(annotation);
            }

            public boolean isVisibleAnnotationPresent(Field f, Class annotation) {
                return f.isAnnotationPresent(annotation);
            }

            public boolean isVisibleAnnotationPresent(Constructor con, Class annotation) {
                return con.isAnnotationPresent(annotation);
            }

            public Object[] getVisibleAnnotations(Class clazz) throws Exception {
                return clazz.getAnnotations();
            }

            public Object[] getVisibleAnnotations(Method m) throws Exception {
                return m.getAnnotations();
            }

            public Object[] getVisibleAnnotations(Field f) throws Exception {
                return f.getAnnotations();
            }

            public Object[] getVisibleAnnotations(Constructor c) throws Exception {
                return c.getAnnotations();
            }
        };
        public static final AnnotationElementAction PRIVILEGED = new AnnotationElementAction(){

            public Object getVisibleAnnotation(final Method method, final Class annotation) {
                return AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return method.getAnnotation(annotation);
                    }
                });
            }

            public Object getVisibleAnnotation(final Constructor con, final Class annotation) {
                return AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return con.getAnnotation(annotation);
                    }
                });
            }

            public Object getVisibleAnnotation(final Field field, final Class annotation) {
                return AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return field.getAnnotation(annotation);
                    }
                });
            }

            public Object getVisibleAnnotation(final Class clazz, final Class annotation) {
                return AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getAnnotation(annotation);
                    }
                });
            }

            public boolean isVisibleAnnotationPresent(final Class clazz, final Class annotation) {
                Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            public boolean isVisibleAnnotationPresent(final Method m, final Class annotation) {
                Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return m.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            public boolean isVisibleAnnotationPresent(final Field f, final Class annotation) {
                Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return f.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            public boolean isVisibleAnnotationPresent(final Constructor con, final Class annotation) {
                Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return con.isAnnotationPresent(annotation) ? Boolean.TRUE : Boolean.FALSE;
                    }
                });
                return present;
            }

            public Object[] getVisibleAnnotations(final Class clazz) throws Exception {
                try {
                    return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            public Object[] getVisibleAnnotations(final Method m) throws Exception {
                try {
                    return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return m.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            public Object[] getVisibleAnnotations(final Field f) throws Exception {
                try {
                    return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return f.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }

            public Object[] getVisibleAnnotations(final Constructor c) throws Exception {
                try {
                    return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return c.getAnnotations();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };

        public Object getVisibleAnnotation(Method var1, Class var2);

        public Object getVisibleAnnotation(Constructor var1, Class var2);

        public Object getVisibleAnnotation(Field var1, Class var2);

        public Object getVisibleAnnotation(Class var1, Class var2);

        public boolean isVisibleAnnotationPresent(Class var1, Class var2);

        public boolean isVisibleAnnotationPresent(Method var1, Class var2);

        public boolean isVisibleAnnotationPresent(Field var1, Class var2);

        public boolean isVisibleAnnotationPresent(Constructor var1, Class var2);

        public Object[] getVisibleAnnotations(Class var1) throws Exception;

        public Object[] getVisibleAnnotations(Method var1) throws Exception;

        public Object[] getVisibleAnnotations(Field var1) throws Exception;

        public Object[] getVisibleAnnotations(Constructor var1) throws Exception;
    }
}

