/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.junit;

import java.net.URL;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.AbstractTestDelegate;

public class AbstractProxyTestDelegate
extends AbstractTestDelegate {
    public AbstractProxyTestDelegate(Class clazz) throws Exception {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.log.debug("Security enabled: " + this.enableSecurity);
        try {
            this.deploy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.undeploy();
    }

    protected void deploy() throws Exception {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + ".xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url == null) {
            throw new RuntimeException("No test specific deployment " + testName);
        }
        this.deploy(url);
    }

    protected void undeploy() {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + ".xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.undeploy(url);
        } else {
            this.log.debug("No test specific deployment " + testName);
        }
    }

    protected URL getTestURL() {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + ".xml";
        return this.clazz.getClassLoader().getResource(testName);
    }

    protected void deploy(URL url) throws Exception {
        this.log.debug("Deploying " + url);
        AspectXmlLoader.deployXML(url);
    }

    protected void undeploy(URL url) {
        try {
            this.log.debug("Undeploying " + url);
            AspectXmlLoader.undeployXML(url);
        }
        catch (Exception e) {
            this.log.warn("Ignored error undeploying " + url, e);
        }
    }
}

