/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.lifecycle;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManager {
    AspectManager manager;
    Map<String, AspectDefinition> lifecycles = new LinkedHashMap<String, AspectDefinition>();
    Map<String, LifecycleCallbackBinding> lifecycleBindings = new LinkedHashMap<String, LifecycleCallbackBinding>();

    public LifecycleManager(AspectManager manager) {
        this.manager = manager;
    }

    public void addLifecycleDefinition(AspectDefinition def) {
        AspectDefinition old = this.lifecycles.put(def.getName(), def);
        if (old != null) {
            old.undeploy();
        }
    }

    public void removeLifecycleDefinition(String name) {
        this.lifecycles.remove(name);
    }

    public void addLifecycleBinding(LifecycleCallbackBinding lifecycleBinding) {
        this.lifecycleBindings.put(lifecycleBinding.getName(), lifecycleBinding);
    }

    public void removeLifecycleBinding(String name) {
        this.lifecycleBindings.remove(name);
    }

    public Map<String, LifecycleCallbackBinding> getLifecycleBindings() {
        return this.lifecycleBindings;
    }
}

