/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.classloader.plugins.system.ClassLoaderSystemBuilder;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
import org.jboss.logging.Logger;
import org.jboss.util.loading.Translator;

public abstract class ClassLoaderSystem
extends BaseClassLoaderSystem {
    private static final Logger log = Logger.getLogger(ClassLoaderSystem.class);
    public static final String DEFAULT_DOMAIN_NAME = "<DEFAULT>";
    private static final ClassLoaderSystemBuilder builder = new ClassLoaderSystemBuilder();
    private ClassLoaderDomain defaultDomain;
    private Map<String, ClassLoaderDomain> registeredDomains = new HashMap<String, ClassLoaderDomain>();
    private Translator translator;
    private boolean shutdown = false;

    public static final ClassLoaderSystem getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        return builder.get();
    }

    public synchronized ClassLoaderDomain getDefaultDomain() {
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        this.defaultDomain = this.registeredDomains.get(DEFAULT_DOMAIN_NAME);
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        this.defaultDomain = this.createDefaultDomain();
        this.internalRegisterDomain(DEFAULT_DOMAIN_NAME, this.defaultDomain);
        return this.defaultDomain;
    }

    protected ClassLoaderDomain createDefaultDomain() {
        return this.createDomain(DEFAULT_DOMAIN_NAME);
    }

    protected abstract ClassLoaderDomain createDomain(String var1);

    public ClassLoaderDomain createAndRegisterDomain(String name) {
        return this.createAndRegisterDomain(name, ParentPolicy.BEFORE, null);
    }

    public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy) {
        return this.createAndRegisterDomain(name, parentPolicy, null);
    }

    public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy, Loader parent) {
        ClassLoaderDomain result = this.createDomain(name);
        result.setParentPolicy(parentPolicy);
        result.setParent(parent);
        this.registerDomain(result);
        return result;
    }

    public synchronized ClassLoaderDomain getDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        ClassLoaderDomain result = this.registeredDomains.get(name);
        if (result == null && DEFAULT_DOMAIN_NAME.equals(name)) {
            result = this.getDefaultDomain();
        }
        return result;
    }

    public boolean isRegistered(String name) {
        return this.getDomain(name) != null;
    }

    public boolean isDomainRegistered(ClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        return this.getDomain(domain.getName()) == domain;
    }

    public synchronized void registerDomain(ClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        String name = domain.getName();
        if (this.isRegistered(name)) {
            throw new IllegalStateException("A domain is already registered with name " + name);
        }
        this.internalRegisterDomain(name, domain);
    }

    private void internalRegisterDomain(String name, ClassLoaderDomain domain) {
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        this.registeredDomains.put(name, domain);
        super.registerDomain(domain);
        log.debug(this + " registered domain=" + domain.toLongString());
    }

    public synchronized void unregisterDomain(ClassLoaderDomain domain) {
        if (!this.isDomainRegistered(domain)) {
            throw new IllegalStateException("Domain is not registered " + domain);
        }
        if (DEFAULT_DOMAIN_NAME.equals(domain.getName())) {
            throw new IllegalArgumentException("Cannot unregister the default domain");
        }
        this.internalUnregisterDomain(domain);
    }

    private synchronized void internalUnregisterDomain(ClassLoaderDomain domain) {
        this.registeredDomains.remove(domain.getName());
        super.unregisterDomain(domain);
        log.debug(this + " unregistered domain=" + domain.toLongString());
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderPolicy policy) {
        return this.registerClassLoaderPolicy(this.getDefaultDomain(), policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader registerClassLoaderPolicy(ClassLoaderDomain domain, ClassLoaderPolicy policy) {
        if (!this.isDomainRegistered(domain)) {
            throw new IllegalStateException("Domain is not registered: " + domain);
        }
        ClassLoaderSystem classLoaderSystem = this;
        synchronized (classLoaderSystem) {
            if (this.shutdown) {
                throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
            }
        }
        return super.registerClassLoaderPolicy(domain, policy);
    }

    public void unregisterClassLoaderPolicy(ClassLoaderPolicy policy) {
        super.unregisterClassLoaderPolicy(policy);
    }

    public void unregisterClassLoader(ClassLoader classLoader) {
        super.unregisterClassLoader(classLoader);
    }

    public synchronized void shutdown() {
        ArrayList<ClassLoaderDomain> domains;
        Iterator iterator;
        if (this.shutdown) {
            return;
        }
        log.debug(this.toLongString() + " SHUTDOWN!");
        this.shutdown = true;
        while ((iterator = (domains = new ArrayList<ClassLoaderDomain>(this.registeredDomains.values())).iterator()).hasNext()) {
            while (iterator.hasNext()) {
                ClassLoaderDomain domain = (ClassLoaderDomain)iterator.next();
                this.internalUnregisterDomain(domain);
            }
        }
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        log.debug(this + " set translator to " + translator);
        this.translator = translator;
    }

    protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        if (this.translator != null) {
            return this.translator.transform(classLoader, className, null, protectionDomain, byteCode);
        }
        return super.transform(classLoader, className, byteCode, protectionDomain);
    }

    protected void afterUnregisterClassLoader(ClassLoader classLoader) {
        try {
            if (this.translator != null) {
                this.translator.unregisterClassLoader(classLoader);
            }
        }
        catch (Throwable t) {
            log.warn("Error unregistering classloader from translator " + classLoader, t);
        }
    }

    protected void toLongString(StringBuilder builder) {
        if (this.shutdown) {
            builder.append("SHUTDOWN! ");
        }
        super.toLongString(builder);
    }
}

