/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.filter;

import java.util.Arrays;
import org.jboss.classloader.plugins.filter.PatternClassFilter;

public class PackageClassFilter
extends PatternClassFilter {
    private String[] packageNames;

    private static String[] convertPackageNamesToClassPatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            patterns[i] = packageNames[i].length() == 0 ? "[^.]*" : packageNames[i].replace(".", "\\.") + "\\.[^.]+";
        }
        return patterns;
    }

    private static String[] convertPackageNamesToResourcePatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            patterns[i] = packageNames[i].length() == 0 ? "[^/]*" : packageNames[i].replace(".", "/") + "/[^/]+";
        }
        return patterns;
    }

    public static PackageClassFilter createPackageClassFilter(String ... packageNames) {
        return new PackageClassFilter(packageNames);
    }

    public PackageClassFilter(String[] packageNames) {
        super(PackageClassFilter.convertPackageNamesToClassPatterns(packageNames), PackageClassFilter.convertPackageNamesToResourcePatterns(packageNames));
        this.packageNames = packageNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.asList(this.packageNames));
        if (this.isIncludeJava()) {
            builder.append(" <INCLUDE_JAVA>");
        }
        return builder.toString();
    }
}

