/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import java.io.Serializable;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class Cardinality
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final int INFINITY = -1;
    public static final Cardinality ZERO_TO_ONE = new Cardinality("0..1", 0, 1);
    public static final Cardinality ZERO_TO_MANY = new Cardinality("0..n", 0, -1);
    public static final Cardinality ONE_TO_ONE = new Cardinality("1..1", 1, 1);
    public static final Cardinality ONE_TO_MANY = new Cardinality("1..n", 1, -1);
    private static Cardinality[] values = new Cardinality[]{ZERO_TO_ONE, ZERO_TO_MANY, ONE_TO_ONE, ONE_TO_MANY};
    private String type;
    private int left;
    private int right;

    private Cardinality(String type, int left, int right) {
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public boolean isInRange(int number) {
        return !(number < 0 || number < this.left || this.left == -1) && (number <= this.right || this.right == -1);
    }

    public static Cardinality toCardinality(String type) {
        for (Cardinality c : values) {
            if (!c.getType().equals(type)) continue;
            return c;
        }
        return Cardinality.fromString(type);
    }

    protected static int getLimitFromString(String limit) {
        try {
            return Integer.parseInt(limit);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected static String getLimitFromInt(int limit) {
        return limit == -1 ? "n" : String.valueOf(limit);
    }

    public static Cardinality fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null string.");
        }
        if (string.contains("..")) {
            String[] args = string.split("\\.\\.");
            if (args == null || args.length != 2) {
                throw new IllegalArgumentException("Illegal cardinality format: " + string);
            }
            return Cardinality.createCardinality(Cardinality.getLimitFromString(args[0]), Cardinality.getLimitFromString(args[1]));
        }
        return Cardinality.createUnlimitedCardinality(Cardinality.getLimitFromString(string));
    }

    public static Cardinality createUnlimitedCardinality(int start) {
        return Cardinality.createCardinality(start, -1);
    }

    public static Cardinality createLimitedCardinality(int end) {
        return Cardinality.createCardinality(0, end);
    }

    public static Cardinality createCardinality(int left, int right) {
        return new Cardinality(Cardinality.getLimitFromInt(left) + ".." + Cardinality.getLimitFromInt(right), left, right);
    }

    protected int getHashCode() {
        return this.type.hashCode();
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("type=").append(this.type);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("type=").append(this.type);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cardinality)) {
            return false;
        }
        Cardinality card = (Cardinality)obj;
        return this.left == card.left && this.right == card.right;
    }

    public String getType() {
        return this.type;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public boolean isLeftInfinity() {
        return this.left <= -1;
    }

    public boolean isRightInfinity() {
        return this.right <= -1;
    }
}

