/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.structure.spi.classloading.ExportAll;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageVisitor
implements VirtualFileVisitor {
    private Set<String> packages = new HashSet<String>();
    private String rootPath;
    private ExportAll exportAll;

    public PackageVisitor(ExportAll exportAll) {
        if (exportAll == null) {
            throw new IllegalArgumentException("Null exportAll policy");
        }
        this.exportAll = exportAll;
    }

    public void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.rootPath = root.getPathName() + "/";
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    @Override
    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(true);
        attributes.setRecurseFilter(VisitorAttributes.RECURSE_ALL);
        return attributes;
    }

    @Override
    public void visit(VirtualFile file) {
        try {
            if (!file.isLeaf()) {
                boolean empty = true;
                if (this.exportAll == ExportAll.ALL) {
                    empty = false;
                } else {
                    List<VirtualFile> children = file.getChildren();
                    if (children != null && !children.isEmpty()) {
                        for (VirtualFile child : children) {
                            if (!child.isLeaf()) continue;
                            empty = false;
                            break;
                        }
                    }
                }
                if (!empty) {
                    String path = file.getPathName();
                    if (path.startsWith(this.rootPath)) {
                        path = path.substring(this.rootPath.length());
                    }
                    this.packages.add(path.replace('/', '.'));
                }
            }
        }
        catch (IOException e) {
            throw new Error("Error visiting " + file, e);
        }
    }
}

