/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.jar;

import java.io.IOException;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.jar.JarUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARStructure
extends AbstractStructureDeployer {
    public JARStructure() {
        this(null);
    }

    public JARStructure(Set<String> suffixes) {
        if (suffixes != null) {
            this.setSuffixes(suffixes);
        }
        this.setRelativeOrder(10000);
    }

    public Set<String> getSuffixes() {
        return JarUtils.getSuffixes();
    }

    public void setSuffixes(Set<String> suffixes) {
        JarUtils.setJarSuffixes(suffixes);
    }

    @Override
    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        ContextInfo context = null;
        try {
            if (!this.isLeaf(file)) {
                if (!JarUtils.isArchive(file.getName())) {
                    if (!this.isTopLevel(parent)) {
                        try {
                            file.findChild("META-INF");
                            this.log.trace("... ok - non top level directory has a META-INF subdirectory");
                        }
                        catch (IOException e) {
                            this.log.trace("... no - doesn't look like a jar and no META-INF subdirectory.");
                            return false;
                        }
                    } else {
                        this.log.trace("... ok - doesn't look like a jar but it is a top level directory.");
                    }
                }
            } else if (JarUtils.isArchive(file.getName())) {
                this.log.trace("... ok - its an archive or at least pretending to be.");
            } else {
                this.log.trace("... no - not a directory or an archive.");
                return false;
            }
            context = this.createContext(file, "META-INF", metaData);
            super.addClassPath(root, file, true, true, context);
            this.addAllChildren(root, file, metaData, deployers);
            return true;
        }
        catch (Exception e) {
            if (context != null) {
                metaData.removeContext(context);
            }
            throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
        }
    }
}

