/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.logging.Logger;

public class BMPPersistenceManager
implements EntityPersistenceManager {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    Logger log = Logger.getLogger(BMPPersistenceManager.class);
    EntityContainer con;
    Method ejbLoad;
    Method ejbStore;
    Method ejbActivate;
    Method ejbPassivate;
    Method ejbRemove;
    Method isModified;
    HashMap createMethods = new HashMap();
    HashMap postCreateMethods = new HashMap();
    HashMap finderMethods = new HashMap();

    public void setContainer(Container c) {
        this.con = (EntityContainer)c;
    }

    public void create() throws Exception {
        Method[] methods;
        this.ejbLoad = EntityBean.class.getMethod("ejbLoad", new Class[0]);
        this.ejbStore = EntityBean.class.getMethod("ejbStore", new Class[0]);
        this.ejbActivate = EntityBean.class.getMethod("ejbActivate", new Class[0]);
        this.ejbPassivate = EntityBean.class.getMethod("ejbPassivate", new Class[0]);
        this.ejbRemove = EntityBean.class.getMethod("ejbRemove", new Class[0]);
        if (this.con.getHomeClass() != null) {
            methods = this.con.getHomeClass().getMethods();
            this.createMethodCache(methods);
        }
        if (this.con.getLocalHomeClass() != null) {
            methods = this.con.getLocalHomeClass().getMethods();
            this.createMethodCache(methods);
        }
        try {
            this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
            if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
                this.isModified = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Object createBeanClassInstance() throws Exception {
        return this.con.getBeanClass().newInstance();
    }

    private void createMethodCache(Method[] methods) throws NoSuchMethodException {
        int i;
        for (i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("create")) continue;
            String nameSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                this.createMethods.put(methods[i], this.con.getBeanClass().getMethod("ejb" + nameSuffix, methods[i].getParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                this.log.error("Home Method " + methods[i] + " not implemented in bean class " + this.con.getBeanClass() + " looking for method named: ejb" + nameSuffix);
                throw e;
            }
            try {
                this.postCreateMethods.put(methods[i], this.con.getBeanClass().getMethod("ejbPost" + nameSuffix, methods[i].getParameterTypes()));
                continue;
            }
            catch (NoSuchMethodException e) {
                this.log.error("Home Method " + methods[i] + " not implemented in bean class " + this.con.getBeanClass() + " looking for method named: ejbPost" + nameSuffix);
                throw e;
            }
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("find")) continue;
            try {
                this.finderMethods.put(methods[i], this.con.getBeanClass().getMethod("ejbF" + methods[i].getName().substring(1), methods[i].getParameterTypes()));
                continue;
            }
            catch (NoSuchMethodException e) {
                this.log.error("Home Method " + methods[i] + " not implemented in bean class");
                throw e;
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        Object id = null;
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
                Method createMethod = (Method)this.createMethods.get(m);
                id = createMethod.invoke(ctx.getInstance(), args);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof CreateException) {
                    throw (CreateException)e;
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw (Error)e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
        ctx.setId(id);
        Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
        ctx.setCacheKey(cacheKey);
    }

    public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_POST_CREATE);
                Method postCreateMethod = (Method)this.postCreateMethods.get(m);
                postCreateMethod.invoke(ctx.getInstance(), args);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof CreateException) {
                    throw (CreateException)e;
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw (Error)e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws Exception {
        Object object;
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
            Object objectId = this.callFinderMethod(finderMethod, args, ctx);
            Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(objectId);
            object = factory.getEntityEJBObject(cacheKey);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws Exception {
        Object result;
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
            result = this.callFinderMethod(finderMethod, args, ctx);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
        if (result == null) {
            return new ArrayList();
        }
        if (result instanceof Enumeration) {
            ArrayList<Object> array = new ArrayList<Object>();
            Enumeration e = (Enumeration)result;
            while (e.hasMoreElements()) {
                Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(e.nextElement());
                Object o = factory.getEntityEJBObject(cacheKey);
                array.add(o);
            }
            return array;
        }
        if (result instanceof Collection) {
            ArrayList<Object> array = new ArrayList<Object>(((Collection)result).size());
            Iterator i = ((Collection)result).iterator();
            while (i.hasNext()) {
                Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(i.next());
                Object o = factory.getEntityEJBObject(cacheKey);
                array.add(o);
            }
            return array;
        }
        throw new EJBException("result of finder method is not a valid return type: " + result.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activateEntity(EntityEnterpriseContext ctx) throws RemoteException {
        Object id = ctx.getId();
        Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
        ctx.setCacheKey(cacheKey);
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
                this.ejbActivate.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                Object var7_5 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadEntity(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_LOAD);
                this.ejbLoad.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                Object var5_3 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
    }

    public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception {
        if (this.isModified == null) {
            return true;
        }
        Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
        return modified;
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        return this.isStoreRequired(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invokeEjbStore(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            if (!this.isStoreRequired(ctx)) {
                return;
            }
        }
        catch (Exception e) {
            throw new EJBException("Failed to invoke isModified().", e);
        }
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
                this.ejbStore.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                Object var5_6 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
    }

    public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passivateEntity(EntityEnterpriseContext ctx) throws RemoteException {
        block8: {
            try {
                try {
                    AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
                    this.ejbPassivate.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
                }
                catch (IllegalAccessException e) {
                    throw new EJBException(e);
                }
                catch (InvocationTargetException ite) {
                    Throwable e = ite.getTargetException();
                    if (e instanceof RemoteException) {
                        throw (RemoteException)e;
                    }
                    if (e instanceof EJBException) {
                        throw (EJBException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw new EJBException((Exception)e);
                    }
                    Object var5_3 = null;
                    AllowedOperationsAssociation.popInMethodFlag();
                    break block8;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                throw throwable;
            }
            AllowedOperationsAssociation.popInMethodFlag();
        }
        ctx.setEJBObject(null);
        ctx.setEJBLocalObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeEntity(EntityEnterpriseContext ctx) throws RemoteException, RemoveException {
        try {
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
                this.ejbRemove.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException e) {
                throw new EJBException(e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof RemoveException) {
                    throw (RemoveException)e;
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                Object var5_3 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            AllowedOperationsAssociation.popInMethodFlag();
            throw throwable;
        }
        AllowedOperationsAssociation.popInMethodFlag();
    }

    private Object callFinderMethod(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        Method callMethod = (Method)this.finderMethods.get(finderMethod);
        if (callMethod == null) {
            throw new EJBException("couldn't find finder method in bean class. " + finderMethod.toString());
        }
        Object result = null;
        try {
            result = callMethod.invoke(ctx.getInstance(), args);
        }
        catch (IllegalAccessException e) {
            throw new EJBException(e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof FinderException) {
                throw (FinderException)e;
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        return result;
    }
}

