/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.RelationData;
import org.jboss.ejb.plugins.cmp.jdbc.RelationPair;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.logging.Logger;

public final class JDBCDeleteRelationsCommand {
    private final Logger log;
    private int maxKeysInDelete;
    private String maxKeysStatement;

    public JDBCDeleteRelationsCommand(JDBCStoreManager manager) {
        this.log = Logger.getLogger(this.getClass().getName() + "." + manager.getMetaData().getName());
        this.maxKeysInDelete = manager.getJDBCTypeFactory().getTypeMapping().getMaxKeysInDelete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RelationData relationData) {
        if (relationData.removedRelations.size() == 0) {
            return;
        }
        Iterator pairs = relationData.removedRelations.iterator();
        int i = 0;
        while (i < relationData.removedRelations.size()) {
            Object var11_11;
            String sql = this.getSQL(relationData, relationData.removedRelations.size() - i);
            Connection con = null;
            PreparedStatement ps = null;
            JDBCCMRFieldBridge cmrField = relationData.getLeftCMRField();
            try {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Executing SQL: " + sql);
                    }
                    DataSource dataSource = cmrField.getDataSource();
                    con = dataSource.getConnection();
                    ps = con.prepareStatement(sql);
                    this.setParameters(ps, relationData, pairs);
                    int rowsAffected = ps.executeUpdate();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rows affected = " + rowsAffected);
                    }
                    i += this.maxKeysInDelete > 0 ? this.maxKeysInDelete : relationData.removedRelations.size();
                }
                catch (Exception e) {
                    throw new EJBException("Could not delete relations from " + cmrField.getQualifiedTableName(), e);
                }
                var11_11 = null;
            }
            catch (Throwable throwable) {
                var11_11 = null;
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
        }
        return;
    }

    private String getSQL(RelationData relationData, int keys) {
        if (this.maxKeysInDelete > 0 && keys >= this.maxKeysInDelete) {
            if (this.maxKeysStatement == null) {
                this.maxKeysStatement = JDBCDeleteRelationsCommand.createSQL(relationData, this.maxKeysInDelete);
            }
            return this.maxKeysStatement;
        }
        return JDBCDeleteRelationsCommand.createSQL(relationData, keys);
    }

    private static String createSQL(RelationData relationData, int keysInDelete) {
        JDBCCMRFieldBridge left = relationData.getLeftCMRField();
        JDBCCMRFieldBridge right = relationData.getRightCMRField();
        StringBuffer sql = new StringBuffer(300);
        sql.append("DELETE FROM ").append(left.getQualifiedTableName()).append(" WHERE ");
        StringBuffer whereClause = new StringBuffer(20);
        whereClause.append('(');
        SQLUtil.getWhereClause(left.getTableKeyFields(), whereClause).append(" AND ");
        SQLUtil.getWhereClause(right.getTableKeyFields(), whereClause).append(')');
        String whereClauseStr = whereClause.toString();
        sql.append(whereClauseStr);
        for (int i = 1; i < keysInDelete; ++i) {
            sql.append(" OR ").append(whereClauseStr);
        }
        return sql.toString();
    }

    private void setParameters(PreparedStatement ps, RelationData relationData, Iterator pairs) throws Exception {
        int index = 1;
        JDBCCMPFieldBridge[] leftFields = (JDBCCMPFieldBridge[])relationData.getLeftCMRField().getTableKeyFields();
        JDBCCMPFieldBridge[] rightFields = (JDBCCMPFieldBridge[])relationData.getRightCMRField().getTableKeyFields();
        int keyIndex = 0;
        while (pairs.hasNext()) {
            RelationPair pair = (RelationPair)pairs.next();
            Object leftId = pair.getLeftId();
            for (int i = 0; i < leftFields.length; ++i) {
                index = leftFields[i].setPrimaryKeyParameters(ps, index, leftId);
            }
            Object rightId = pair.getRightId();
            for (int i = 0; i < rightFields.length; ++i) {
                index = rightFields[i].setPrimaryKeyParameters(ps, index, rightId);
            }
            if (this.maxKeysInDelete <= 0 || ++keyIndex != this.maxKeysInDelete) continue;
            break;
        }
    }
}

