/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;

public abstract class JDBCInsertPKCreateCommand
extends JDBCAbstractCreateCommand {
    protected String existsSQL;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
        if (this.exceptionProcessor == null) {
            this.initExistsSQL();
        }
    }

    protected void initExistsSQL() {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT ").append("COUNT(*)").append(" FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
        SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
        this.existsSQL = sql.toString();
        if (this.debug) {
            this.log.debug("Entity Exists SQL: " + this.existsSQL);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void beforeInsert(EntityEnterpriseContext ctx) throws CreateException {
        if (this.existsSQL == null) return;
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                if (this.debug) {
                    this.log.debug("Executing SQL: " + this.existsSQL);
                }
                c = this.entity.getDataSource().getConnection();
                ps = c.prepareStatement(this.existsSQL);
                Object pk = this.entity.extractPrimaryKeyFromInstance(ctx);
                this.entity.setPrimaryKeyParameters(ps, 1, pk);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new CreateException("Error checking if entity with primary pk " + pk + "exists: SQL returned no rows");
                }
                if (rs.getInt(1) > 0) {
                    throw new DuplicateKeyException("Entity with primary key " + pk + " already exists");
                }
                Object var7_7 = null;
            }
            catch (SQLException e) {
                this.log.error("Error checking if entity exists", e);
                throw new CreateException("Error checking if entity exists:" + e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(c);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(c);
    }
}

