/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValueClassMetaData;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationMetaData;
import org.w3c.dom.Element;

public final class JDBCApplicationMetaData {
    private static final Class JDBC_PM = JDBCStoreManager.class;
    private final ClassLoader classLoader;
    private final ApplicationMetaData applicationMetaData;
    private final Map userTypeMappings;
    private final Map typeMappings = new HashMap();
    private final Map entities = new HashMap();
    private final Collection relationships = new HashSet();
    private final Map entityRoles = new HashMap();
    private final Map valueClasses = new HashMap();
    private final Map entitiesByAbstractSchemaName = new HashMap();
    private final Map entitiesByInterface = new HashMap();
    private final Map entityCommands = new HashMap();

    public JDBCApplicationMetaData(ApplicationMetaData applicationMetaData, ClassLoader classLoader) throws DeploymentException {
        this.classLoader = classLoader;
        this.applicationMetaData = applicationMetaData;
        Iterator<BeanMetaData> beans = applicationMetaData.getEnterpriseBeans();
        while (beans.hasNext()) {
            Class local;
            Class remote;
            Class<?> pm;
            BeanMetaData bean = beans.next();
            if (!bean.isEntity()) continue;
            EntityMetaData entity = (EntityMetaData)bean;
            try {
                pm = classLoader.loadClass(entity.getContainerConfiguration().getPersistenceManager());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Unable to load persistence manager", e);
            }
            if (!entity.isCMP() || !JDBC_PM.isAssignableFrom(pm) && !pm.getName().equals("org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2")) continue;
            JDBCEntityMetaData jdbcEntity = new JDBCEntityMetaData(this, entity);
            this.entities.put(entity.getEjbName(), jdbcEntity);
            String schemaName = jdbcEntity.getAbstractSchemaName();
            if (schemaName != null) {
                this.entitiesByAbstractSchemaName.put(schemaName, jdbcEntity);
            }
            if ((remote = jdbcEntity.getRemoteClass()) != null) {
                this.entitiesByInterface.put(remote, jdbcEntity);
            }
            if ((local = jdbcEntity.getLocalClass()) != null) {
                this.entitiesByInterface.put(local, jdbcEntity);
            }
            this.entityRoles.put(entity.getEjbName(), new HashSet());
        }
        Iterator<RelationMetaData> iterator = applicationMetaData.getRelationships();
        while (iterator.hasNext()) {
            RelationMetaData relation = iterator.next();
            JDBCRelationMetaData jdbcRelation = new JDBCRelationMetaData(this, relation);
            this.relationships.add(jdbcRelation);
            JDBCRelationshipRoleMetaData left = jdbcRelation.getLeftRelationshipRole();
            Collection leftEntityRoles = (Collection)this.entityRoles.get(left.getEntity().getName());
            leftEntityRoles.add(left);
            JDBCRelationshipRoleMetaData right = jdbcRelation.getRightRelationshipRole();
            Collection rightEntityRoles = (Collection)this.entityRoles.get(right.getEntity().getName());
            rightEntityRoles.add(right);
        }
        this.userTypeMappings = Collections.EMPTY_MAP;
    }

    public JDBCApplicationMetaData(Element element, JDBCApplicationMetaData defaultValues) throws DeploymentException {
        Element enterpriseBeans;
        Element rWords;
        this.classLoader = defaultValues.classLoader;
        this.applicationMetaData = defaultValues.applicationMetaData;
        Element userTypeMaps = MetaData.getOptionalChild(element, "user-type-mappings");
        if (userTypeMaps != null) {
            this.userTypeMappings = new HashMap();
            Iterator iter = MetaData.getChildrenByTagName(userTypeMaps, "user-type-mapping");
            while (iter.hasNext()) {
                Element userTypeMappingEl = (Element)iter.next();
                JDBCUserTypeMappingMetaData userTypeMapping = new JDBCUserTypeMappingMetaData(userTypeMappingEl);
                this.userTypeMappings.put(userTypeMapping.getJavaType(), userTypeMapping);
            }
        } else {
            this.userTypeMappings = defaultValues.getUserTypeMappings();
        }
        this.typeMappings.putAll(defaultValues.typeMappings);
        Element typeMaps = MetaData.getOptionalChild(element, "type-mappings");
        if (typeMaps != null) {
            Iterator i = MetaData.getChildrenByTagName(typeMaps, "type-mapping");
            while (i.hasNext()) {
                Element typeMappingElement = (Element)i.next();
                JDBCTypeMappingMetaData typeMapping = new JDBCTypeMappingMetaData(typeMappingElement);
                this.typeMappings.put(typeMapping.getName(), typeMapping);
            }
        }
        this.valueClasses.putAll(defaultValues.valueClasses);
        Element valueClassesElement = MetaData.getOptionalChild(element, "dependent-value-classes");
        if (valueClassesElement != null) {
            Iterator i = MetaData.getChildrenByTagName(valueClassesElement, "dependent-value-class");
            while (i.hasNext()) {
                Element valueClassElement = (Element)i.next();
                JDBCValueClassMetaData valueClass = new JDBCValueClassMetaData(valueClassElement, this.classLoader);
                this.valueClasses.put(valueClass.getJavaType(), valueClass);
            }
        }
        this.entityCommands.putAll(defaultValues.entityCommands);
        Element entityCommandMaps = MetaData.getOptionalChild(element, "entity-commands");
        if (entityCommandMaps != null) {
            Iterator i = MetaData.getChildrenByTagName(entityCommandMaps, "entity-command");
            while (i.hasNext()) {
                Element entityCommandElement = (Element)i.next();
                JDBCEntityCommandMetaData entityCommand = new JDBCEntityCommandMetaData(entityCommandElement);
                this.entityCommands.put(entityCommand.getCommandName(), entityCommand);
            }
        }
        if ((rWords = MetaData.getOptionalChild(element, "reserved-words")) != null) {
            Iterator i = MetaData.getChildrenByTagName(rWords, "word");
            while (i.hasNext()) {
                Element rWord = (Element)i.next();
                SQLUtil.addToRwords(MetaData.getElementContent(rWord));
            }
        }
        this.entities.putAll(defaultValues.entities);
        this.entitiesByAbstractSchemaName.putAll(defaultValues.entitiesByAbstractSchemaName);
        this.entitiesByInterface.putAll(defaultValues.entitiesByInterface);
        Element defaults = MetaData.getOptionalChild(element, "defaults");
        if (defaults != null) {
            ArrayList values = new ArrayList(this.entities.values());
            for (JDBCEntityMetaData entityMetaData : values) {
                Class local;
                Class remote;
                entityMetaData = new JDBCEntityMetaData(this, defaults, entityMetaData);
                this.entities.put(entityMetaData.getName(), entityMetaData);
                String schemaName = entityMetaData.getAbstractSchemaName();
                if (schemaName != null) {
                    this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
                }
                if ((remote = entityMetaData.getRemoteClass()) != null) {
                    this.entitiesByInterface.put(remote, entityMetaData);
                }
                if ((local = entityMetaData.getLocalClass()) == null) continue;
                this.entitiesByInterface.put(local, entityMetaData);
            }
        }
        if ((enterpriseBeans = MetaData.getOptionalChild(element, "enterprise-beans")) != null) {
            Iterator<Object> i = MetaData.getChildrenByTagName(enterpriseBeans, "entity");
            while (i.hasNext()) {
                Class local;
                Class remote;
                Element beanElement = (Element)i.next();
                String ejbName = MetaData.getUniqueChildContent(beanElement, "ejb-name");
                JDBCEntityMetaData entityMetaData = this.getBeanByEjbName(ejbName);
                if (entityMetaData == null) {
                    throw new DeploymentException("Configuration found in jbosscmp-jdbc.xml for entity " + ejbName + " but bean " + "is not a jbosscmp-jdbc-managed cmp entity in " + "ejb-jar.xml");
                }
                entityMetaData = new JDBCEntityMetaData(this, beanElement, entityMetaData);
                this.entities.put(entityMetaData.getName(), entityMetaData);
                String schemaName = entityMetaData.getAbstractSchemaName();
                if (schemaName != null) {
                    this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
                }
                if ((remote = entityMetaData.getRemoteClass()) != null) {
                    this.entitiesByInterface.put(remote, entityMetaData);
                }
                if ((local = entityMetaData.getLocalClass()) == null) continue;
                this.entitiesByInterface.put(local, entityMetaData);
            }
        }
        if (defaults == null) {
            this.relationships.addAll(defaultValues.relationships);
            this.entityRoles.putAll(defaultValues.entityRoles);
        } else {
            for (JDBCEntityMetaData entity : this.entities.values()) {
                this.entityRoles.put(entity.getName(), new HashSet());
            }
            for (JDBCRelationMetaData relationMetaData : defaultValues.relationships) {
                relationMetaData = new JDBCRelationMetaData(this, defaults, relationMetaData);
                this.relationships.add(relationMetaData);
                JDBCRelationshipRoleMetaData left = relationMetaData.getLeftRelationshipRole();
                Collection leftEntityRoles = (Collection)this.entityRoles.get(left.getEntity().getName());
                leftEntityRoles.add(left);
                JDBCRelationshipRoleMetaData right = relationMetaData.getRightRelationshipRole();
                Collection rightEntityRoles = (Collection)this.entityRoles.get(right.getEntity().getName());
                rightEntityRoles.add(right);
            }
        }
        Element relationshipsElement = MetaData.getOptionalChild(element, "relationships");
        if (relationshipsElement != null) {
            HashMap<String, JDBCRelationMetaData> relationByName = new HashMap<String, JDBCRelationMetaData>();
            for (JDBCRelationMetaData relation : this.relationships) {
                if (relation.getRelationName() == null) continue;
                relationByName.put(relation.getRelationName(), relation);
            }
            Iterator i = MetaData.getChildrenByTagName(relationshipsElement, "ejb-relation");
            while (i.hasNext()) {
                Element relationElement = (Element)i.next();
                String relationName = MetaData.getUniqueChildContent(relationElement, "ejb-relation-name");
                JDBCRelationMetaData oldRelation = (JDBCRelationMetaData)relationByName.get(relationName);
                if (oldRelation == null) {
                    throw new DeploymentException("Configuration found in jbosscmp-jdbc.xml for relation " + relationName + " but relation is not a jbosscmp-jdbc-managed relation " + "in ejb-jar.xml");
                }
                JDBCRelationMetaData newRelation = new JDBCRelationMetaData(this, relationElement, oldRelation);
                this.relationships.remove(oldRelation);
                this.relationships.add(newRelation);
                JDBCRelationshipRoleMetaData newLeft = newRelation.getLeftRelationshipRole();
                Collection leftEntityRoles = (Collection)this.entityRoles.get(newLeft.getEntity().getName());
                leftEntityRoles.remove(oldRelation.getLeftRelationshipRole());
                leftEntityRoles.add(newLeft);
                JDBCRelationshipRoleMetaData newRight = newRelation.getRightRelationshipRole();
                Collection rightEntityRoles = (Collection)this.entityRoles.get(newRight.getEntity().getName());
                rightEntityRoles.remove(oldRelation.getRightRelationshipRole());
                rightEntityRoles.add(newRight);
            }
        }
    }

    public JDBCTypeMappingMetaData getTypeMappingByName(String name) {
        return (JDBCTypeMappingMetaData)this.typeMappings.get(name);
    }

    public Collection getRolesForEntity(String entityName) {
        Collection roles = (Collection)this.entityRoles.get(entityName);
        return Collections.unmodifiableCollection(roles);
    }

    public Collection getValueClasses() {
        return Collections.unmodifiableCollection(this.valueClasses.values());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JDBCEntityMetaData getBeanByEjbName(String name) {
        return (JDBCEntityMetaData)this.entities.get(name);
    }

    public JDBCEntityCommandMetaData getEntityCommandByName(String name) {
        return (JDBCEntityCommandMetaData)this.entityCommands.get(name);
    }

    public Map getUserTypeMappings() {
        return Collections.unmodifiableMap(this.userTypeMappings);
    }
}

