/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.FinderException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.DeclaredSQLQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.DynamicQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.EJBQLQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.FindByPrimaryKeyCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JBossQLQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;

public class QueryFactory {
    private final Map queriesByMethod = new HashMap();
    private final JDBCEntityBridge2 entity;

    public QueryFactory(JDBCEntityBridge2 entity) {
        this.entity = entity;
    }

    public QueryCommand getQueryCommand(Method queryMethod) throws FinderException {
        QueryCommand queryCommand = (QueryCommand)this.queriesByMethod.get(queryMethod);
        if (queryCommand == null) {
            throw new FinderException("Unknown query method: " + queryMethod);
        }
        return queryCommand;
    }

    public void init() throws DeploymentException {
        Class local;
        Method findByPkMethod;
        Class home = this.entity.getHomeClass();
        if (home != null) {
            try {
                findByPkMethod = home.getMethod("findByPrimaryKey", this.entity.getPrimaryKeyClass());
            }
            catch (NoSuchMethodException e) {
                throw new DeploymentException("Home interface " + home.getClass().getName() + " does not contain findByPrimaryKey(" + this.entity.getPrimaryKeyClass().getName() + ")");
            }
            FindByPrimaryKeyCommand findByPk = new FindByPrimaryKeyCommand(this.entity);
            this.queriesByMethod.put(findByPkMethod, findByPk);
        }
        if ((local = this.entity.getLocalHomeClass()) != null) {
            try {
                findByPkMethod = local.getMethod("findByPrimaryKey", this.entity.getPrimaryKeyClass());
            }
            catch (NoSuchMethodException e) {
                throw new DeploymentException("Local home interface " + local.getClass().getName() + " does not contain findByPrimaryKey(" + this.entity.getPrimaryKeyClass().getName() + ")");
            }
            FindByPrimaryKeyCommand findByPk = new FindByPrimaryKeyCommand(this.entity);
            this.queriesByMethod.put(findByPkMethod, findByPk);
        }
        for (JDBCQueryMetaData q : this.entity.getMetaData().getQueries()) {
            QueryCommand queryCommand;
            if (this.queriesByMethod.containsKey(q.getMethod())) continue;
            if (q instanceof JDBCJBossQLQueryMetaData) {
                queryCommand = new JBossQLQueryCommand(this.entity, (JDBCJBossQLQueryMetaData)q);
                this.queriesByMethod.put(q.getMethod(), queryCommand);
                continue;
            }
            if (q instanceof JDBCQlQueryMetaData) {
                queryCommand = new EJBQLQueryCommand(this.entity, (JDBCQlQueryMetaData)q);
                this.queriesByMethod.put(q.getMethod(), queryCommand);
                continue;
            }
            if (q instanceof JDBCDeclaredQueryMetaData) {
                queryCommand = new DeclaredSQLQueryCommand(this.entity, (JDBCDeclaredQueryMetaData)q);
                this.queriesByMethod.put(q.getMethod(), queryCommand);
                continue;
            }
            if (q instanceof JDBCDynamicQLQueryMetaData) {
                queryCommand = new DynamicQueryCommand(this.entity, (JDBCDynamicQLQueryMetaData)q);
                this.queriesByMethod.put(q.getMethod(), queryCommand);
                continue;
            }
            throw new DeploymentException("Unsupported query metadata: method=" + q.getMethod().getName() + ", metadata=" + q);
        }
    }
}

