/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb.txtimer.EJBTimerServiceImpl;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class EJBTimerServiceLocator {
    private static Logger log = Logger.getLogger(EJBTimerServiceLocator.class);
    private static EJBTimerService ejbTimerService;

    public static EJBTimerService getEjbTimerService() {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (server != null && server.isRegistered(EJBTimerService.OBJECT_NAME)) {
                ejbTimerService = new MBeanDelegate(server);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (ejbTimerService == null) {
            EJBTimerServiceImpl ejbTimerServiceImpl = new EJBTimerServiceImpl();
            ejbTimerService = ejbTimerServiceImpl;
            try {
                ejbTimerServiceImpl.create();
                ejbTimerServiceImpl.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start EJBTimerService", e);
            }
        }
        return ejbTimerService;
    }

    public static class MBeanDelegate
    implements EJBTimerService {
        private EJBTimerService mbeanEjbTimerService;

        public MBeanDelegate(MBeanServer server) {
            try {
                this.mbeanEjbTimerService = (EJBTimerService)MBeanProxyExt.create(EJBTimerService.class, EJBTimerService.OBJECT_NAME, server);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create EJBTimerService proxy: " + e.getMessage());
            }
        }

        public TimerService createTimerService(ObjectName containerId, Object instancePk, Container container) throws IllegalStateException {
            try {
                TimerService timerService = this.mbeanEjbTimerService.createTimerService(containerId, instancePk, container);
                return timerService;
            }
            catch (Exception e) {
                log.error("Cannot createTimerService", e);
                return null;
            }
        }

        public TimerService createTimerService(ObjectName containerId, Object instancePk, TimedObjectInvoker invoker) throws IllegalStateException {
            try {
                TimerService timerService = this.mbeanEjbTimerService.createTimerService(containerId, instancePk, invoker);
                return timerService;
            }
            catch (Exception e) {
                log.error("Cannot createTimerService", e);
                return null;
            }
        }

        public TimerService getTimerService(ObjectName containerId, Object instancePk) throws IllegalStateException {
            try {
                TimerService timerService = this.mbeanEjbTimerService.getTimerService(containerId, instancePk);
                return timerService;
            }
            catch (Exception e) {
                log.error("Cannot getTimerService", e);
                return null;
            }
        }

        public void removeTimerService(ObjectName containerId, Object instancePk) throws IllegalStateException {
            try {
                this.mbeanEjbTimerService.removeTimerService(containerId, instancePk);
            }
            catch (Exception e) {
                log.error("Cannot removeTimerService", e);
            }
        }

        public void removeTimerService(ObjectName containerId, boolean keepState) throws IllegalStateException {
            try {
                this.mbeanEjbTimerService.removeTimerService(containerId, keepState);
            }
            catch (Exception e) {
                log.error("Cannot removeTimerService", e);
            }
        }

        public void restoreTimers(ObjectName containerId, ClassLoader loader) throws IllegalStateException {
            try {
                this.mbeanEjbTimerService.restoreTimers(containerId, loader);
            }
            catch (Exception e) {
                log.error("Cannot restoreTimer", e);
            }
        }
    }
}

