/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.net.URL;
import java.util.HashMap;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
import org.jboss.ejb3.protocol.jarjar.Handler;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitParsingDeployer
extends AbstractVFSParsingDeployer<PersistenceUnitsMetaData> {
    private static final Logger log = Logger.getLogger(PersistenceUnitParsingDeployer.class);

    public PersistenceUnitParsingDeployer() {
        super(PersistenceUnitsMetaData.class);
        this.setName("persistence.xml");
    }

    @Override
    protected PersistenceUnitsMetaData parse(DeploymentUnit unit, String name, PersistenceUnitsMetaData root) throws Exception {
        PersistenceUnitsMetaData result;
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
        if (file == null) {
            try {
                file = vfsDeploymentUnit.getFile("WEB-INF/classes/META-INF/persistence.xml");
                if (file == null) {
                    return null;
                }
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        if ((result = this.parse(vfsDeploymentUnit, file, root)) != null) {
            this.init(vfsDeploymentUnit, result, file);
        }
        return result;
    }

    @Override
    protected PersistenceUnitsMetaData parse(VFSDeploymentUnit unit, VirtualFile file, PersistenceUnitsMetaData root) throws Exception {
        VirtualFile persistenceRoot = file.getParent().getParent();
        URL persistenceUnitRootUrl = persistenceRoot.getHandler().toURL();
        assert (persistenceUnitRootUrl.getProtocol().equals("jar") || persistenceUnitRootUrl.getProtocol().equals("file")) : "expected a jar or file url, but was " + persistenceUnitRootUrl;
        URL persistenceXmlUrl = file.toURL();
        PersistenceUnitsMetaData metaData = new PersistenceUnitsMetaData(persistenceUnitRootUrl, PersistenceXmlLoader.deploy((URL)persistenceXmlUrl, new HashMap(), (EntityResolver)new EJB3DTDEntityResolver(), (PersistenceUnitTransactionType)PersistenceUnitTransactionType.JTA));
        log.info("Found persistence units " + metaData);
        return metaData;
    }

    static {
        Handler.init();
    }
}

