/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.annotation.impl.LocalBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingsImpl;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDeployer {
    private static final Logger log = Logger.getLogger(ProxyDeployer.class);
    private SessionContainer container;
    private ArrayList<ProxyFactory> proxyFactories = new ArrayList();
    private RemoteBindings remoteBindings;
    private LocalBinding localBinding;

    public ProxyDeployer(SessionContainer container) {
        assert (container != null) : "container is null";
        this.container = container;
    }

    public List<ProxyFactory> getProxyFactories() {
        return this.proxyFactories;
    }

    public void start() throws Exception {
        if (this.remoteBindings != null) {
            RemoteBinding[] list2;
            for (RemoteBinding binding : list2 = this.remoteBindings.value()) {
                RemoteProxyFactory factory;
                assert (binding.jndiBinding().length() != 0) : "jndiBinding not set on binding " + binding;
                String factoryImplementationRegistryKey = binding.factory();
                if (factoryImplementationRegistryKey.equals("RemoteProxyFactory")) {
                    factory = this.container.createRemoteProxyFactory(binding);
                } else {
                    Class<? extends RemoteProxyFactory> remoteFactoryClass = this.container.getDeployment().getRemoteProxyFactoryRegistry().getProxyFactoryClass(binding.factory());
                    Constructor<? extends RemoteProxyFactory> constructor = remoteFactoryClass.getConstructor(SessionContainer.class, RemoteBinding.class);
                    factory = constructor.newInstance(this.container, binding);
                }
                factory.start();
                this.proxyFactories.add(factory);
            }
        }
        if (this.localBinding != null) {
            ProxyFactory factory = this.container.createProxyFactory(this.localBinding);
            factory.start();
            this.proxyFactories.add(factory);
        }
    }

    protected boolean hasJNDIBinding(String jndiName) {
        assert (jndiName != null) : "jndiName is null";
        if (this.localBinding != null && this.localBinding.jndiBinding().equals(jndiName)) {
            return true;
        }
        if (this.remoteBindings != null) {
            for (RemoteBinding binding : this.remoteBindings.value()) {
                if (!binding.jndiBinding().equals(jndiName)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeLocalBindingMetadata() {
        this.localBinding = (LocalBinding)this.container.resolveAnnotation(LocalBinding.class);
        if (this.localBinding == null && ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this.container).length > 0) {
            this.localBinding = new LocalBindingImpl(ProxyFactoryHelper.getLocalJndiName(this.container));
            this.container.getAnnotations().addClassAnnotation(LocalBinding.class, this.localBinding);
        }
    }

    private RemoteBinding initializeRemoteBinding(RemoteBinding binding) {
        if (binding.jndiBinding().length() == 0) {
            return new RemoteBindingImpl(ProxyFactoryHelper.getDefaultRemoteJndiName(this.container), binding.interceptorStack(), binding.clientBindUrl(), binding.factory());
        }
        return binding;
    }

    public void initializeRemoteBindingMetadata() {
        this.remoteBindings = (RemoteBindings)this.container.resolveAnnotation(RemoteBindings.class);
        if (this.remoteBindings == null) {
            RemoteBinding binding = (RemoteBinding)this.container.resolveAnnotation(RemoteBinding.class);
            if (binding == null) {
                log.debug("no declared remote bindings for : " + this.container.getEjbName());
                if (ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container).length > 0) {
                    log.debug("there is remote interfaces for " + this.container.getEjbName());
                    String jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
                    log.debug("default remote binding has jndiName of " + jndiName);
                    String uri = "";
                    RemoteBinding[] list2 = new RemoteBinding[]{new RemoteBindingImpl(jndiName, "", uri, "RemoteProxyFactory")};
                    this.remoteBindings = new RemoteBindingsImpl(list2);
                    this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
                }
            } else {
                RemoteBinding[] list3 = new RemoteBinding[]{this.initializeRemoteBinding(binding)};
                this.remoteBindings = new RemoteBindingsImpl(list3);
                this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
            }
        } else {
            ArrayList<RemoteBinding> list4 = new ArrayList<RemoteBinding>();
            for (RemoteBinding binding : this.remoteBindings.value()) {
                list4.add(this.initializeRemoteBinding(binding));
            }
            this.remoteBindings = new RemoteBindingsImpl(list4);
            this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
        }
    }

    public void stop() throws Exception {
        for (int i = 0; i < this.proxyFactories.size(); ++i) {
            ProxyFactory factory = this.proxyFactories.get(i);
            factory.stop();
        }
    }
}

