/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import org.jboss.logging.Logger;
import org.jboss.proxy.compiler.IIOPStubCompiler;

public class StubClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(StubClassLoader.class);

    public StubClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int start;
        logger.debug("findClass(" + name + ") called");
        if (name.endsWith("_Stub") && name.charAt(start = name.lastIndexOf(46) + 1) == '_') {
            String pkg = name.substring(0, start);
            String interfaceName = pkg + name.substring(start + 1, name.length() - 5);
            logger.debug("interface name " + interfaceName);
            Class<?> intf = this.loadClass(interfaceName);
            logger.debug("loaded class " + interfaceName);
            try {
                byte[] code = IIOPStubCompiler.compile(intf, name);
                logger.debug("compiled stub class for " + interfaceName);
                Class<?> clz = this.defineClass(name, code, 0, code.length);
                logger.debug("defined stub class for " + interfaceName);
                this.resolveClass(clz);
                logger.debug("resolved stub class for " + interfaceName);
                return clz;
            }
            catch (RuntimeException e) {
                logger.debug("Exception generating IIOP stub " + name, e);
                throw e;
            }
        }
        throw new ClassNotFoundException(name);
    }
}

