/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.container;

import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.logging.Logger;

public class ServerLogInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ServerLogInterceptor.class);
    private boolean trace = log.isTraceEnabled();

    public String getName() {
        return "ServerLogInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Method method = null;
        String methodName = null;
        Object target = null;
        if (this.trace) {
            target = invocation.getTargetObject();
            if (!(invocation instanceof MethodInvocation)) {
                log.trace("invoking non-method invocation: " + invocation + " on " + target);
            } else {
                MethodInvocation mi = (MethodInvocation)invocation;
                method = mi.getMethod();
                methodName = method.getName();
                StringBuffer sb = new StringBuffer();
                sb.append("invoking ").append(target).append('.').append(methodName).append('(');
                Object[] args = mi.getArguments();
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        if ("createConnectionDelegate".equals(methodName) && i == 1) {
                            sb.append("*****");
                        } else {
                            sb.append(args[i]);
                        }
                        if (i >= args.length - 1) continue;
                        sb.append(", ");
                    }
                }
                sb.append(')');
                log.trace(sb.toString());
            }
        }
        Object result = invocation.invokeNext();
        if (this.trace) {
            if (method == null) {
                log.trace(invocation + " successfully invoked on " + target);
            } else if (method.getReturnType() != Void.TYPE) {
                log.trace(target + "." + methodName + "() returned " + result);
            } else {
                log.trace(target + "." + methodName + "() OK");
            }
        }
        return result;
    }
}

