/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.remoting;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.logging.Logger;

public class CountingOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(CountingOutputStream.class);
    private OutputStream os;
    private int count;
    private boolean trace = true;

    public CountingOutputStream(OutputStream os) {
        this.os = os;
    }

    public void write(int b) throws IOException {
        this.os.write(b);
        if (this.trace) {
            log.trace(this + "Wrote byte " + this.count + ": " + b);
        }
        ++this.count;
    }

    public void flush() throws IOException {
        this.os.flush();
        if (this.trace) {
            log.trace(this + "Flushed stream");
            this.count = 0;
        }
    }
}

