/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionUnsubscribeRequest
extends RequestSupport {
    private String subName;

    public SessionUnsubscribeRequest() {
    }

    public SessionUnsubscribeRequest(String objectId, byte version, String subName) {
        super(objectId, 311, version);
        this.subName = subName;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.subName = is.readUTF();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.unsubscribe(this.subName);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.subName);
        os.flush();
    }
}

