/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.basic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;

public class BasicBootstrap
extends AbstractBootstrap {
    public static void main(String[] args) throws Exception {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
    }

    public BasicBootstrap() {
        Properties props = this.getConfigProperties();
        if (props == null) {
            props = this.getSystemProperties();
        }
        final PropertyKernelConfig config = new PropertyKernelConfig(props);
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(config);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public BasicBootstrap(final KernelConfig config) throws Exception {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(config);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    protected Properties getConfigProperties() {
        return null;
    }

    private Properties getSystemProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(GetSystemProperties.instance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSystemProperties
    implements PrivilegedAction<Properties> {
        private static GetSystemProperties instance = new GetSystemProperties();

        private GetSystemProperties() {
        }

        @Override
        public Properties run() {
            return System.getProperties();
        }
    }
}

