/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature {
    public static final String NO_NAME = "?%NO_NAME%?";
    public static final String[] NO_PARAMETERS = new String[0];
    public static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private String name;
    private String[] parameters;
    private Class<?>[] parameterTypes;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private static final Map<String, Class<?>> primitiveTypes = new HashMap();
    private static final Map<String, String> primitiveArrayTypes = new HashMap<String, String>();
    private static final Map<String, Class<?>> primitiveArrayTypesClassMap = new HashMap();

    public static Signature getSignature(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        if (member instanceof Method) {
            Method method = (Method)Method.class.cast(member);
            return new MethodSignature(method);
        }
        if (member instanceof Field) {
            Field field = (Field)Field.class.cast(member);
            return new FieldSignature(field);
        }
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)Constructor.class.cast(member);
            return new ConstructorSignature(constructor);
        }
        throw new IllegalArgumentException("Unknown member: " + member);
    }

    public static Signature getSignature(MemberInfo member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        if (member instanceof MethodInfo) {
            MethodInfo method = (MethodInfo)MethodInfo.class.cast(member);
            return new MethodSignature(method);
        }
        if (member instanceof FieldInfo) {
            FieldInfo field = (FieldInfo)FieldInfo.class.cast(member);
            return new FieldSignature(field);
        }
        if (member instanceof ConstructorInfo) {
            ConstructorInfo constructor = (ConstructorInfo)ConstructorInfo.class.cast(member);
            return new ConstructorSignature(constructor);
        }
        throw new IllegalArgumentException("Unknown member: " + member);
    }

    public static String getPrimativeArrayType(String name) {
        return primitiveArrayTypes.get(name);
    }

    public static String[] convertParameters(TypeInfo[] typeInfos) {
        if (typeInfos == null || typeInfos.length == 0) {
            return NO_PARAMETERS;
        }
        String[] paramTypes = new String[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getName();
        }
        return paramTypes;
    }

    public static Class<?>[] convertParameterTypes(TypeInfo[] typeInfos) {
        if (typeInfos == null || typeInfos.length == 0) {
            return NO_PARAMETER_TYPES;
        }
        Class[] paramTypes = new Class[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getType();
        }
        return paramTypes;
    }

    private static String[] classesToStrings(Class<?> ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return NO_PARAMETERS;
        }
        String[] result = new String[parameters.length];
        for (int i = 0; i < result.length; ++i) {
            if (parameters[i] == null) {
                throw new IllegalArgumentException("Null class");
            }
            result[i] = parameters[i].getName();
        }
        return result;
    }

    private static Class<?>[] stringsToClasses(Class<?> clazz, String ... parameters) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null && (cl = Class.class.getClassLoader()) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return Signature.stringsToClasses(cl, parameters);
    }

    private static Class<?> loadClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Class<?> primitive = primitiveTypes.get(name);
        if (primitive != null) {
            return primitive;
        }
        int index = name.lastIndexOf(91);
        if (index >= 0) {
            Class<?> componentType;
            int arrayDimension = 0;
            while (name.charAt(arrayDimension) == '[') {
                ++arrayDimension;
            }
            if (name.charAt(arrayDimension) == 'L') {
                String arrayType = name.substring(arrayDimension + 1, name.length() - 1);
                componentType = Signature.loadClass(cl, arrayType);
            } else {
                String arrayType = name.substring(arrayDimension);
                componentType = primitiveArrayTypesClassMap.get(arrayType);
            }
            return Array.newInstance(componentType, new int[arrayDimension]).getClass();
        }
        return Class.forName(name, true, cl);
    }

    private static Class<?>[] stringsToClasses(ClassLoader cl, String ... parameters) {
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (parameters == null || parameters.length == 0) {
            return NO_PARAMETER_TYPES;
        }
        Class[] result = new Class[parameters.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = Signature.loadClass(cl, parameters[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class not found: " + parameters[i], e);
            }
        }
        return result;
    }

    public Signature() {
        this(NO_NAME, NO_PARAMETER_TYPES, NO_PARAMETERS);
    }

    public Signature(String name) {
        this(name, (Class<?>[])null, NO_PARAMETERS);
    }

    public Signature(String ... parameters) {
        this(NO_NAME, (Class<?>[])null, parameters);
    }

    public Signature(Class<?> ... parameters) {
        this(NO_NAME, parameters, (String[])null);
    }

    public Signature(String name, Class<?> ... parameters) {
        this(name, parameters, (String[])null);
    }

    public Signature(String name, String ... parameters) {
        this(name, (Class<?>[])null, parameters);
    }

    private Signature(String name, Class<?>[] parameterTypes, String[] parameters) {
        this.name = name;
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
        if (name == null) {
            this.name = NO_NAME;
        }
        if (parameters == null) {
            this.parameters = Signature.classesToStrings(parameterTypes);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] != null) continue;
            throw new IllegalArgumentException("Null parameter");
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public Class<?>[] getParametersTypes(Class<?> clazz) {
        if (this.parameterTypes == null) {
            return Signature.stringsToClasses(clazz, this.parameters);
        }
        return this.parameterTypes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(other.parameters[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            this.cachedHashCode = this.toString().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.internalToString(builder);
        return builder.toString();
    }

    protected void internalToString(StringBuilder builder) {
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.parameters != null) {
            builder.append(Arrays.asList(this.parameters));
        }
    }

    static {
        primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
        primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
        primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
        primitiveArrayTypes.put(Byte.TYPE.getName(), "B");
        primitiveArrayTypes.put(Boolean.TYPE.getName(), "Z");
        primitiveArrayTypes.put(Character.TYPE.getName(), "C");
        primitiveArrayTypes.put(Double.TYPE.getName(), "D");
        primitiveArrayTypes.put(Float.TYPE.getName(), "F");
        primitiveArrayTypes.put(Integer.TYPE.getName(), "I");
        primitiveArrayTypes.put(Long.TYPE.getName(), "J");
        primitiveArrayTypes.put(Short.TYPE.getName(), "S");
        primitiveArrayTypesClassMap.put("B", Byte.TYPE);
        primitiveArrayTypesClassMap.put("Z", Boolean.TYPE);
        primitiveArrayTypesClassMap.put("C", Character.TYPE);
        primitiveArrayTypesClassMap.put("D", Double.TYPE);
        primitiveArrayTypesClassMap.put("F", Float.TYPE);
        primitiveArrayTypesClassMap.put("I", Integer.TYPE);
        primitiveArrayTypesClassMap.put("J", Long.TYPE);
        primitiveArrayTypesClassMap.put("S", Short.TYPE);
    }
}

