/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

class MLetRepositoryClassLoader
extends RepositoryClassLoader {
    private static final Logger log = Logger.getLogger(MLetRepositoryClassLoader.class);
    private MLet mlet;

    protected MLetRepositoryClassLoader(MLet mlet) {
        super(mlet.getURLs(), (ClassLoader)mlet);
        this.mlet = mlet;
    }

    public ObjectName getObjectName() {
        throw new UnsupportedOperationException("Not relevent");
    }

    public URL[] getClasspath() {
        return this.mlet.getURLs();
    }

    public URL[] getAllURLs() {
        return this.repository.getURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt) throws ClassNotFoundException {
        ClassLoadingTask task;
        block18: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
            }
            if (this.repository == null) {
                String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
                throw new ClassNotFoundException(msg, this.unregisterTrace);
            }
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace("Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepository3 ulr3;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.registerLoaderThread(this, t);
                }
                if (LoadMgr3.beginLoadTask(task = new ClassLoadingTask(name, this, t, stopAt), ulr3 = (UnifiedLoaderRepository3)this.repository)) break block18;
                while (task.threadTaskCount != 0) {
                    try {
                        LoadMgr3.nextTask(t, task, ulr3);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
        }
        if (this.loadLock.holds() == 1L) {
            LoadMgr3.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        if (task.loadedClass != null) {
            return task.loadedClass;
        }
        if (task.loadException instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)task.loadException;
        }
        if (task.loadException == null) {
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        if (log.isTraceEnabled()) {
            log.trace("Unexpected error during load of:" + name, task.loadException);
        }
        String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
        throw new ClassNotFoundException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("loadClassLocally, " + this + " name=" + name);
        }
        Class<?> result = null;
        try {
            Class<?> clazz = result = this.mlet.loadClass(name, null);
            return clazz;
        }
        finally {
            if (trace) {
                if (result != null) {
                    log.trace("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader());
                } else {
                    log.trace("loadClassLocally, " + this + " name=" + name + " not found");
                }
            }
        }
    }
}

