/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.util.UnreachableStatementException;

public class CompositeDataInvocationHandler
implements InvocationHandler {
    private CompositeData compositeData;

    public CompositeDataInvocationHandler(CompositeData compositeData) {
        if (compositeData == null) {
            throw new IllegalArgumentException("Null compositeData");
        }
        this.compositeData = compositeData;
    }

    public CompositeData getCompositeData() {
        return this.compositeData;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return this.handleObjectInvocation(method.getName(), args);
        }
        Object value = this.getValue(method);
        Type returnType = method.getGenericReturnType();
        return MXBeanUtils.reconstruct(returnType, value, method);
    }

    private Object getValue(Method method) {
        String key = MXBeanUtils.getCompositeDataKey(method);
        if (key == null) {
            throw new IllegalArgumentException("Unsupported method '" + method + "'; it must be a property getter.");
        }
        try {
            return this.compositeData.get(key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Unsupported method '" + method + "'; it must be a property getter for one of the item names of the composite data: " + this.compositeData, e);
        }
    }

    private Object handleObjectInvocation(String name, Object[] args) throws Throwable {
        if ("equals".equals(name)) {
            Object object = args[0];
            if (object == null || !(object instanceof Proxy)) {
                return false;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(object);
            if (handler == this) {
                return true;
            }
            if (handler == null || !(handler instanceof CompositeDataInvocationHandler)) {
                return false;
            }
            CompositeDataInvocationHandler other = (CompositeDataInvocationHandler)handler;
            return ((Object)this.getCompositeData()).equals(other.getCompositeData());
        }
        if ("hashCode".equals(name)) {
            return ((Object)this.getCompositeData()).hashCode();
        }
        if ("toString".equals(name)) {
            return ((Object)this.getCompositeData()).toString();
        }
        throw new UnreachableStatementException();
    }
}

