/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.persistence.PersistenceManager;
import org.jboss.util.StringPropertyReplacer;

public class ObjectStreamPersistenceManager
implements PersistenceManager {
    protected static Logger log = Logger.getLogger(ObjectStreamPersistenceManager.class);
    protected boolean isLoading;

    public void load(ModelMBeanInvoker mbean, MBeanInfo metadata) throws MBeanException {
        File storeFile;
        log.debug("load, resource:" + mbean.getResource());
        if (metadata == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("metadata: " + metadata);
        }
        if ((storeFile = this.getStoreFile(metadata, false)) == null) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(storeFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            ModelMBeanInfo storeMetadata = (ModelMBeanInfo)ois.readObject();
            ois.close();
            log.debug("metadata deserialized");
            if (log.isTraceEnabled()) {
                log.trace("storeMetadata: " + storeMetadata);
            }
            this.loadFromMetadata(mbean, storeMetadata);
        }
        catch (Exception e) {
            log.error("Error loading MBean state", e);
        }
    }

    public void store(MBeanInfo metadata) throws MBeanException {
        File storeFile;
        if (this.isLoading()) {
            return;
        }
        log.debug("store");
        if (log.isTraceEnabled()) {
            log.trace("metadata: " + metadata);
        }
        if ((storeFile = this.getStoreFile(metadata, true)) == null) {
            return;
        }
        try {
            log.debug("Storing to file: " + storeFile.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(storeFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(metadata);
        }
        catch (IOException e) {
            throw new MBeanException(e, "Error in persisting MBean.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromMetadata(ModelMBeanInvoker mbean, ModelMBeanInfo metadata) {
        AttributeList attributes = new AttributeList();
        MBeanAttributeInfo[] attrs = metadata.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ModelMBeanAttributeInfo attributeInfo = (ModelMBeanAttributeInfo)attrs[i];
            Descriptor attrDesc = attributeInfo.getDescriptor();
            Object name = attrDesc.getFieldValue("name");
            Object value = attrDesc.getFieldValue("attributeValue");
            Object updated = attrDesc.getFieldValue("lastUpdatedTimeStamp2");
            if (updated == null) continue;
            log.debug("loading attribute  name: " + name + ", value: " + value);
            Attribute curAttribute = new Attribute(name.toString(), value);
            attributes.add(curAttribute);
        }
        try {
            this.setIsLoading(true);
            mbean.setAttributes(attributes);
            Object var13_12 = null;
            this.setIsLoading(false);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.setIsLoading(false);
            throw throwable;
        }
    }

    protected boolean isLoading() {
        return this.isLoading;
    }

    protected void setIsLoading(boolean newIsLoading) {
        this.isLoading = newIsLoading;
    }

    protected File getStoreFile(MBeanInfo metadata, boolean createFile) throws MBeanException {
        Descriptor d = ((ModelMBeanInfo)((Object)metadata)).getMBeanDescriptor();
        String dirPath = (String)d.getFieldValue("persistLocation");
        String file = (String)d.getFieldValue("persistName");
        if (dirPath == null) {
            log.debug("No persistLocation descriptor value found, using '.'");
            dirPath = ".";
        }
        if (file == null) {
            log.debug("No persistName descriptor value found");
            return null;
        }
        dirPath = StringPropertyReplacer.replaceProperties(dirPath);
        file = StringPropertyReplacer.replaceProperties(file);
        File dir = new File(dirPath);
        File storeFile = new File(dir, file);
        boolean exists = storeFile.exists();
        log.debug("Store file is: " + storeFile.getAbsolutePath());
        if (!exists && createFile) {
            dir.mkdirs();
            try {
                storeFile.createNewFile();
            }
            catch (IOException e) {
                throw new MBeanException(e, "Failed to create store file");
            }
        } else if (!exists) {
            storeFile = null;
        }
        return storeFile;
    }
}

