/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.PackageInfoImpl;
import org.jboss.reflect.plugins.TypeInfoAttachments;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistInheritableAnnotationHolder;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTypeInfo
extends JavassistInheritableAnnotationHolder
implements ClassInfo,
InterfaceInfo {
    private static final long serialVersionUID = -5072033691434335775L;
    private JavassistTypeInfoFactoryImpl factory;
    private String name;
    private Class<? extends Object> clazz;
    private Map<SignatureKey, JavassistConstructorInfo> constructors = new ConcurrentHashMap<SignatureKey, JavassistConstructorInfo>();
    private ConstructorInfo[] constructorArray;
    private Map<String, JavassistFieldInfo> fields = new ConcurrentHashMap<String, JavassistFieldInfo>();
    private FieldInfo[] fieldArray;
    private Map<SignatureKey, JavassistMethodInfo> methods = new ConcurrentHashMap<SignatureKey, JavassistMethodInfo>();
    private MethodInfo[] methodArray;
    private PackageInfo packageInfo;
    private transient TypeInfoAttachments attachments;

    JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz) {
        this(factory, ctClass.getName(), ctClass, clazz);
    }

    JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, String name, CtClass ctClass, Class<? extends Object> clazz) {
        super(ctClass, factory);
        this.factory = factory;
        this.clazz = clazz;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    @Override
    public String getSimpleName() {
        return this.getType().getSimpleName();
    }

    @Override
    public int getModifiers() {
        return this.ctClass.getModifiers();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    @Override
    @Deprecated
    public Class<? extends Object> getType() {
        return this.clazz;
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.isInterface()) {
            return null;
        }
        try {
            CtClass superclass = this.ctClass.getSuperclass();
            if (superclass == null) {
                return null;
            }
            return (ClassInfo)this.factory.getTypeInfo(superclass);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(this.clazz.getSuperclass().getName(), e);
        }
    }

    @Override
    public ClassInfo getGenericSuperclass() {
        throw new NotImplementedException("getGenericSuperclass");
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        try {
            CtClass[] interfaces = this.ctClass.getInterfaces();
            if (interfaces == null || interfaces.length == 0) {
                return null;
            }
            InterfaceInfo[] result = new InterfaceInfo[interfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (InterfaceInfo)this.factory.getTypeInfo(interfaces[i]);
            }
            return result;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for interfaces of " + this.getName(), e);
        }
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        throw new NotImplementedException("getGenericInterfaces");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructorArray == null) {
            CtConstructor[] declaredConstructors = this.ctClass.getDeclaredConstructors();
            if (declaredConstructors == null || declaredConstructors.length == 0) {
                this.constructorArray = new ConstructorInfo[0];
            } else {
                Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
                synchronized (map) {
                    for (int i = 0; i < declaredConstructors.length; ++i) {
                        this.generateConstructorInfo(declaredConstructors[i]);
                    }
                    Collection<JavassistConstructorInfo> constructorCollection = this.constructors.values();
                    this.constructorArray = constructorCollection.toArray(new ConstructorInfo[constructorCollection.size()]);
                }
            }
        }
        return this.constructorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstructorInfo getDeclaredConstructor(TypeInfo[] parameters) {
        SignatureKey key = new SignatureKey(null, parameters);
        Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
        synchronized (map) {
            ConstructorInfo constructor = this.constructors.get(key);
            if (constructor != null) {
                return constructor;
            }
        }
        if (this.constructorArray != null) {
            return null;
        }
        return this.generateConstructorInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfo getDeclaredField(String name) {
        Map<String, JavassistFieldInfo> map = this.fields;
        synchronized (map) {
            FieldInfo field = this.fields.get(name);
            if (field != null) {
                return field;
            }
        }
        if (this.fieldArray != null) {
            return null;
        }
        try {
            CtField field = this.ctClass.getDeclaredField(name);
            if (field == null) {
                return null;
            }
            return this.generateFieldInfo(field);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfo[] getDeclaredFields() {
        if (this.fieldArray == null) {
            CtField[] declaredFields = this.ctClass.getDeclaredFields();
            if (declaredFields == null || declaredFields.length == 0) {
                this.fieldArray = new FieldInfo[0];
            } else {
                Map<String, JavassistFieldInfo> map = this.fields;
                synchronized (map) {
                    for (int i = 0; i < declaredFields.length; ++i) {
                        this.generateFieldInfo(declaredFields[i]);
                    }
                    Collection<JavassistFieldInfo> fieldCollection = this.fields.values();
                    this.fieldArray = fieldCollection.toArray(new FieldInfo[fieldCollection.size()]);
                }
            }
        }
        return this.fieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
        SignatureKey key = new SignatureKey(name, parameters);
        Map<SignatureKey, JavassistMethodInfo> map = this.methods;
        synchronized (map) {
            MethodInfo method = this.methods.get(key);
            if (method != null) {
                return method;
            }
        }
        if (this.methodArray != null) {
            return null;
        }
        return this.generateMethodInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodInfo[] getDeclaredMethods() {
        if (this.methodArray == null) {
            CtMethod[] declaredMethods = this.ctClass.getDeclaredMethods();
            if (declaredMethods == null || declaredMethods.length == 0) {
                this.methodArray = new MethodInfo[0];
            } else {
                Map<SignatureKey, JavassistMethodInfo> map = this.methods;
                synchronized (map) {
                    for (int i = 0; i < declaredMethods.length; ++i) {
                        this.generateMethodInfo(declaredMethods[i]);
                    }
                    Collection<JavassistMethodInfo> methodCollection = this.methods.values();
                    this.methodArray = methodCollection.toArray(new MethodInfo[methodCollection.size()]);
                }
            }
        }
        return this.methodArray;
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isAnnotation() {
        return this.getType().isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.getType().isEnum();
    }

    @Override
    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public static Class getArrayClass(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    @Override
    public TypeInfo getArrayType() {
        Class arrayClass = JavassistTypeInfo.getArrayClass(this.getType());
        return this.factory.getTypeInfo(arrayClass);
    }

    @Override
    public Object newArrayInstance(int size) throws Throwable {
        if (!this.isArray()) {
            throw new ClassCastException(this + " is not an array.");
        }
        return Array.newInstance(this.getComponentType().getType(), size);
    }

    @Override
    public boolean isAssignableFrom(TypeInfo info) {
        if (info == null) {
            throw new NullPointerException("Parameter info cannot be null!");
        }
        return this.getType().isAssignableFrom(info.getType());
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return this.factory;
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties, trim);
    }

    @Override
    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return this.getName().equals(other.getName());
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    @Override
    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    protected JavassistTypeInfoFactoryImpl getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConstructorInfo generateConstructorInfo(CtConstructor constructor) {
        try {
            CtClass[] parameterTypes = constructor.getParameterTypes();
            String[] params = new String[parameterTypes.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameterTypes[i].getName();
            }
            SignatureKey key = new SignatureKey(null, params);
            JavassistConstructorInfo info = new JavassistConstructorInfo(this.factory, this, constructor);
            Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
            synchronized (map) {
                this.constructors.put(key, info);
            }
            return info;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for constructor of " + this.getName(), e);
        }
    }

    protected ConstructorInfo generateConstructorInfo(SignatureKey key) {
        CtClass[] params = this.getParameterTypes(key);
        try {
            CtConstructor ctConstructor = this.ctClass.getDeclaredConstructor(params);
            return this.generateConstructorInfo(ctConstructor);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for constructor " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldInfo generateFieldInfo(CtField field) {
        JavassistFieldInfo info = new JavassistFieldInfo(this.factory, this, field);
        Map<String, JavassistFieldInfo> map = this.fields;
        synchronized (map) {
            this.fields.put(field.getName(), info);
        }
        return info;
    }

    protected MethodInfo generateMethodInfo(SignatureKey key) {
        CtClass[] params = this.getParameterTypes(key);
        try {
            CtMethod ctMethod = this.ctClass.getDeclaredMethod(key.name, params);
            return this.generateMethodInfo(key, ctMethod);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for method " + key.name, e);
        }
    }

    protected MethodInfo generateMethodInfo(CtMethod method) {
        try {
            CtClass[] parameterTypes = method.getParameterTypes();
            String[] params = new String[parameterTypes.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameterTypes[i].getName();
            }
            SignatureKey key = new SignatureKey(method.getName(), params);
            return this.generateMethodInfo(key, method);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for method " + method.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodInfo generateMethodInfo(SignatureKey key, CtMethod method) {
        JavassistMethodInfo info = new JavassistMethodInfo(this.factory, this, key, method);
        Map<SignatureKey, JavassistMethodInfo> map = this.methods;
        synchronized (map) {
            this.methods.put(key, info);
        }
        return info;
    }

    protected CtClass[] getParameterTypes(SignatureKey key) {
        if (key.params == null) {
            return null;
        }
        CtClass[] result = new CtClass[key.params.length];
        for (int i = 0; i < key.params.length; ++i) {
            result[i] = this.factory.getCtClass(key.params[i]);
        }
        return result;
    }

    protected Object getAnnotatedTarget() {
        return this.ctClass;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctClass);
    }

    @Override
    public JavassistInheritableAnnotationHolder getSuperHolder() {
        try {
            CtClass zuper = this.ctClass.getSuperclass();
            if (zuper == null) {
                return null;
            }
            return (JavassistTypeInfo)this.factory.getTypeInfo(zuper);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        return null;
    }

    @Override
    public TypeInfo getOwnerType() {
        return null;
    }

    @Override
    public ClassInfo getRawType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        return null;
    }

    @Override
    public TypeInfo getKeyType() {
        return null;
    }

    @Override
    public TypeInfo getValueType() {
        return null;
    }

    @Override
    public PackageInfo getPackage() {
        String name;
        if (this.packageInfo == null && (name = this.ctClass.getPackageName()) != null) {
            this.packageInfo = new PackageInfoImpl(this.ctClass.getPackageName());
        }
        return this.packageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        JavassistTypeInfo javassistTypeInfo = this;
        synchronized (javassistTypeInfo) {
            if (this.attachments == null) {
                if (attachment == null) {
                    return;
                }
                this.attachments = new TypeInfoAttachments();
            }
        }
        if (attachment == null) {
            this.attachments.removeAttachment(name);
        } else {
            this.attachments.addAttachment(name, attachment);
        }
    }

    @Override
    public <T> T getAttachment(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(expectedType.getName());
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        JavassistTypeInfo javassistTypeInfo = this;
        synchronized (javassistTypeInfo) {
            if (this.attachments == null) {
                return null;
            }
        }
        return this.attachments.getAttachment(name);
    }
}

