/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex.invoker;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class Server3Client1 {
    private Client client;
    private SampleCallbackHandler handler;
    private Connector connector;
    private InvokerLocator locator;

    public void init() {
        try {
            String parameters = "/?clientMultiplexId=server3client1";
            String locatorURI = "multiplex://localhost:9090" + parameters;
            InvokerLocator locator = new InvokerLocator(locatorURI);
            this.client = new Client(locator, "sample");
            this.client.connect();
            System.out.println("Connected client to server at: " + this.client.getInvoker().getLocator().getLocatorURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InvokerLocator initServer() throws Exception {
        String parameters = "/?serverMultiplexId=server3client1";
        String locatorURI = "multiplex://localhost:8080" + parameters;
        InvokerLocator locator = new InvokerLocator(locatorURI);
        this.connector = new Connector(locator.getLocatorURI());
        this.connector.create();
        this.connector.start();
        System.out.println("Started callback server at:    " + this.connector.getInvokerLocator());
        return this.connector.getLocator();
    }

    public void setUp() throws Exception {
        this.locator = this.initServer();
        this.init();
    }

    public void tearDown() throws Throwable {
        while (!this.handler.gotCallbacks) {
            Thread.sleep(1000L);
        }
        this.client.removeListener(this.handler);
        if (this.connector != null) {
            this.connector.stop();
            this.connector.destroy();
            this.connector = null;
        }
        this.locator = null;
        if (this.client != null) {
            this.client.disconnect();
            this.client = null;
        }
    }

    public void makeClientCall() throws Throwable {
        this.handler = new SampleCallbackHandler();
        this.client.addListener((InvokerCallbackHandler)this.handler, this.locator, (Object)this.client.getSessionId());
        Object answer = this.client.invoke(new Integer(17));
        System.out.println("invocation returns: " + (Integer)answer);
    }

    public static void main(String[] args) {
        Server3Client1 test = new Server3Client1();
        try {
            test.setUp();
            test.makeClientCall();
            test.tearDown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static class SampleCallbackHandler
    implements InvokerCallbackHandler {
        int callbackCounter;
        boolean gotCallbacks;

        public void handleCallback(Callback callback) throws HandleCallbackException {
            Object ret = callback.getCallbackObject();
            System.out.println("callback value: " + ret);
            if (++this.callbackCounter == 2) {
                this.gotCallbacks = true;
            }
        }

        public boolean gotCallbacks() {
            return this.gotCallbacks;
        }
    }
}

