/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.socketfactory;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;

public class CreationListenerSocketFactory
extends SSLSocketFactory
implements SocketFactoryWrapper,
Serializable {
    private static final long serialVersionUID = 1210774093889434553L;
    private SocketFactory factory;
    private SocketCreationListener listener;

    public CreationListenerSocketFactory(SocketCreationListener listener) {
        this(SocketFactory.getDefault(), listener);
    }

    public CreationListenerSocketFactory(SocketFactory factory, SocketCreationListener listener) {
        this.factory = factory;
        this.listener = listener;
    }

    public SocketFactory getFactory() {
        return this.factory;
    }

    public SocketCreationListener getListener() {
        return this.listener;
    }

    public void setFactory(SocketFactory factory) {
        this.factory = factory;
    }

    public void setListener(SocketCreationListener listener) {
        this.listener = listener;
    }

    public Socket createSocket() throws IOException {
        this.checkFactory();
        Socket socket = this.factory.createSocket();
        this.listener.socketCreated(socket, this.factory);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this.checkFactory();
        Socket socket = this.factory.createSocket(host, port);
        this.listener.socketCreated(socket, this.factory);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        this.checkFactory();
        Socket socket = this.factory.createSocket(host, port, clientHost, clientPort);
        this.listener.socketCreated(socket, this.factory);
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        this.checkFactory();
        Socket socket = this.factory.createSocket(host, port);
        this.listener.socketCreated(socket, this.factory);
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        this.checkFactory();
        Socket socket = this.factory.createSocket(address, port, clientAddress, clientPort);
        this.listener.socketCreated(socket, this.factory);
        return socket;
    }

    public String[] getDefaultCipherSuites() {
        if (this.factory instanceof SSLSocketFactory) {
            return ((SSLSocketFactory)this.factory).getDefaultCipherSuites();
        }
        return null;
    }

    public String[] getSupportedCipherSuites() {
        if (this.factory instanceof SSLSocketFactory) {
            return ((SSLSocketFactory)this.factory).getSupportedCipherSuites();
        }
        return null;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        if (this.factory instanceof SSLSocketFactory) {
            Socket socket = ((SSLSocketFactory)this.factory).createSocket(s, host, port, autoClose);
            this.listener.socketCreated(socket, this.factory);
            return socket;
        }
        return null;
    }

    public SocketFactory getSocketFactory() {
        return this.factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    protected void checkFactory() {
        if (this.factory == null) {
            this.factory = SocketFactory.getDefault();
        }
    }
}

