/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.resource.spi.ConnectionEvent;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsManagedConnection;
import org.jboss.resource.adapter.jms.JmsMessageConsumer;
import org.jboss.resource.adapter.jms.JmsQueueReceiver;
import org.jboss.resource.adapter.jms.JmsSessionFactory;
import org.jboss.resource.adapter.jms.JmsTopicSubscriber;

public class JmsSession
implements Session,
QueueSession,
TopicSession {
    private static final Logger log = Logger.getLogger(JmsSession.class);
    private JmsManagedConnection mc;
    private JmsConnectionRequestInfo info;
    private JmsSessionFactory sf;
    private HashSet consumers = new HashSet();
    private HashSet producers = new HashSet();
    private boolean trace = log.isTraceEnabled();

    public JmsSession(JmsManagedConnection mc, JmsConnectionRequestInfo info) {
        this.mc = mc;
        this.info = info;
        if (this.trace) {
            log.trace("new JmsSession " + this + " mc=" + mc + " cri=" + info);
        }
    }

    public void setJmsSessionFactory(JmsSessionFactory sf) {
        this.sf = sf;
    }

    Session getSession() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        Session session = this.mc.getSession();
        if (this.trace) {
            log.trace("getSession " + session + " for " + this);
        }
        return session;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createBytesMessage" + session);
        }
        return session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createMapMessage" + session);
        }
        return session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createMessage" + session);
        }
        return session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createObjectMessage" + session);
        }
        return session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createObjectMessage(Object)" + session);
        }
        return session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createStreamMessage" + session);
        }
        return session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createTextMessage" + session);
        }
        return session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createTextMessage(String)" + session);
        }
        return session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        this.getSession();
        return this.info.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    public void run() {
        throw new Error("Method not allowed");
    }

    public void close() throws JMSException {
        this.sf.closeSession(this);
        this.closeSession();
    }

    public void commit() throws JMSException {
        Session session = this.getSession();
        if (!this.info.isTransacted()) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.trace) {
            log.trace("Commit session " + this);
        }
        session.commit();
    }

    public void rollback() throws JMSException {
        Session session = this.getSession();
        if (!this.info.isTransacted()) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.trace) {
            log.trace("Rollback session " + this);
        }
        session.rollback();
    }

    public void recover() throws JMSException {
        Session session = this.getSession();
        if (this.info.isTransacted()) {
            throw new IllegalStateException("Session is transacted");
        }
        if (this.trace) {
            log.trace("Recover session " + this);
        }
        session.recover();
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create topic for javax.jms.QueueSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createTopic " + session + " topicName=" + topicName);
        }
        Topic result = session.createTopic(topicName);
        if (this.trace) {
            log.trace("createdTopic " + session + " topic=" + result);
        }
        return result;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSession session = this.getTopicSession();
        if (this.trace) {
            log.trace("createSubscriber " + session + " topic=" + topic);
        }
        TopicSubscriber result = session.createSubscriber(topic);
        result = new JmsTopicSubscriber(result, this);
        if (this.trace) {
            log.trace("createdSubscriber " + session + " JmsTopicSubscriber=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        TopicSession session = this.getTopicSession();
        if (this.trace) {
            log.trace("createSubscriber " + session + " topic=" + topic + " selector=" + messageSelector + " noLocal=" + noLocal);
        }
        TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
        result = new JmsTopicSubscriber(result, this);
        if (this.trace) {
            log.trace("createdSubscriber " + session + " JmsTopicSubscriber=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create durable subscriber from javax.jms.QueueSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name);
        }
        TopicSubscriber result = session.createDurableSubscriber(topic, name);
        result = new JmsTopicSubscriber(result, this);
        if (this.trace) {
            log.trace("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name + " selector=" + messageSelector + " noLocal=" + noLocal);
        }
        TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
        result = new JmsTopicSubscriber(result, this);
        if (this.trace) {
            log.trace("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        TopicSession session = this.getTopicSession();
        if (this.trace) {
            log.trace("createPublisher " + session + " topic=" + topic);
        }
        TopicPublisher result = session.createPublisher(topic);
        if (this.trace) {
            log.trace("createdPublisher " + session + " publisher=" + result);
        }
        this.addProducer(result);
        return result;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create temporary topic for javax.jms.QueueSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createTemporaryTopic " + session);
        }
        TemporaryTopic temp = session.createTemporaryTopic();
        if (this.trace) {
            log.trace("createdTemporaryTopic " + session + " temp=" + temp);
        }
        this.sf.addTemporaryTopic(temp);
        return temp;
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot unsubscribe for javax.jms.QueueSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("unsubscribe " + session + " name=" + name);
        }
        session.unsubscribe(name);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createBrowser " + session + " queue=" + queue);
        }
        QueueBrowser result = session.createBrowser(queue);
        if (this.trace) {
            log.trace("createdBrowser " + session + " browser=" + result);
        }
        return result;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createBrowser " + session + " queue=" + queue + " selector=" + messageSelector);
        }
        QueueBrowser result = session.createBrowser(queue, messageSelector);
        if (this.trace) {
            log.trace("createdBrowser " + session + " browser=" + result);
        }
        return result;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create browser or javax.jms.TopicSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createQueue " + session + " queueName=" + queueName);
        }
        Queue result = session.createQueue(queueName);
        if (this.trace) {
            log.trace("createdQueue " + session + " queue=" + result);
        }
        return result;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        QueueSession session = this.getQueueSession();
        if (this.trace) {
            log.trace("createReceiver " + session + " queue=" + queue);
        }
        QueueReceiver result = session.createReceiver(queue);
        result = new JmsQueueReceiver(result, this);
        if (this.trace) {
            log.trace("createdReceiver " + session + " receiver=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        QueueSession session = this.getQueueSession();
        if (this.trace) {
            log.trace("createReceiver " + session + " queue=" + queue + " selector=" + messageSelector);
        }
        QueueReceiver result = session.createReceiver(queue, messageSelector);
        result = new JmsQueueReceiver(result, this);
        if (this.trace) {
            log.trace("createdReceiver " + session + " receiver=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        QueueSession session = this.getQueueSession();
        if (this.trace) {
            log.trace("createSender " + session + " queue=" + queue);
        }
        QueueSender result = session.createSender(queue);
        if (this.trace) {
            log.trace("createdSender " + session + " sender=" + result);
        }
        this.addProducer(result);
        return result;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create temporary queue for javax.jms.TopicSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createTemporaryQueue " + session);
        }
        TemporaryQueue temp = session.createTemporaryQueue();
        if (this.trace) {
            log.trace("createdTemporaryQueue " + session + " temp=" + temp);
        }
        this.sf.addTemporaryQueue(temp);
        return temp;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createConsumer " + session + " dest=" + destination);
        }
        MessageConsumer result = session.createConsumer(destination);
        result = new JmsMessageConsumer(result, this);
        if (this.trace) {
            log.trace("createdConsumer " + session + " consumer=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector);
        }
        MessageConsumer result = session.createConsumer(destination, messageSelector);
        result = new JmsMessageConsumer(result, this);
        if (this.trace) {
            log.trace("createdConsumer " + session + " consumer=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector + " noLocal=" + noLocal);
        }
        MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
        result = new JmsMessageConsumer(result, this);
        if (this.trace) {
            log.trace("createdConsumer " + session + " consumer=" + result);
        }
        this.addConsumer(result);
        return result;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace("createProducer " + session + " dest=" + destination);
        }
        MessageProducer result = this.getSession().createProducer(destination);
        if (this.trace) {
            log.trace("createdProducer " + session + " producer=" + result);
        }
        this.addProducer(result);
        return result;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.getSession();
        return this.info.getAcknowledgeMode();
    }

    void setManagedConnection(JmsManagedConnection mc) {
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = mc;
    }

    void destroy() {
        this.mc = null;
    }

    void start() throws JMSException {
        if (this.mc != null) {
            this.mc.start();
        }
    }

    void stop() throws JMSException {
        if (this.mc != null) {
            this.mc.stop();
        }
    }

    void checkStrict() throws JMSException {
        if (this.mc != null && this.mc.getManagedConnectionFactory().isStrict()) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws JMSException {
        if (this.mc != null) {
            Iterator i;
            log.trace("Closing session");
            try {
                this.mc.stop();
            }
            catch (Throwable t) {
                log.trace("Error stopping managed connection", t);
            }
            HashSet t = this.consumers;
            synchronized (t) {
                i = this.consumers.iterator();
                while (i.hasNext()) {
                    JmsMessageConsumer consumer = (JmsMessageConsumer)i.next();
                    try {
                        consumer.closeConsumer();
                    }
                    catch (Throwable t2) {
                        log.trace("Error closing consumer", t2);
                    }
                    i.remove();
                }
            }
            t = this.producers;
            synchronized (t) {
                i = this.producers.iterator();
                while (i.hasNext()) {
                    MessageProducer producer = (MessageProducer)i.next();
                    try {
                        producer.close();
                    }
                    catch (Throwable t3) {
                        log.trace("Error closing producer", t3);
                    }
                    i.remove();
                }
            }
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent(this.mc, 1);
            ev.setConnectionHandle(this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer consumer) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer consumer) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer producer) {
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer producer) {
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            this.producers.remove(producer);
        }
    }

    QueueSession getQueueSession() throws JMSException {
        Session s = this.getSession();
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
        }
        return (QueueSession)s;
    }

    TopicSession getTopicSession() throws JMSException {
        Session s = this.getSession();
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
        }
        return (TopicSession)s;
    }
}

