/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.DescriptionGroupMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.system.ServiceDynamicMBeanSupport;
import org.jboss.util.Classes;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionFactoryDeployment
extends ServiceDynamicMBeanSupport
implements ManagedConnectionFactory {
    private static final long serialVersionUID = -8448602289610025849L;
    public static final String MCF_ATTRIBUTE_CHANGED_NOTIFICATION = "jboss.mcfattributechangednotification";
    private Logger log = Logger.getLogger(this.getClass());
    private ObjectName oldRarDeployment;
    private String rarName;
    private String connectionDefinition;
    private String vendorName;
    private String specVersion;
    private String eisType;
    private String version;
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private String transactionSupport;
    private Element managedConnectionFactoryProperties;
    private String authenticationMechanismType;
    private String credentialInterface;
    private boolean reauthenticationSupport;
    private Class mcfClass;
    private String jndiName;
    private ManagedConnectionFactory mcf;
    private ManagedConnectionFactoryDeploymentMetaData dmd;
    private ConnectorMetaData cmd;

    public ManagedConnectionFactoryDeployment() {
    }

    public ManagedConnectionFactoryDeployment(ConnectorMetaData cmd, ManagedConnectionFactoryDeploymentMetaData dmd) {
        this.cmd = cmd;
        this.dmd = dmd;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getRARName() {
        return this.rarName;
    }

    public void setRARName(String rarName) {
        this.rarName = rarName;
    }

    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    public void setConnectionDefinition(String connectionDefinition) {
        this.connectionDefinition = connectionDefinition;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public void setConnectionImplClass(String connectionImplClass) {
        this.connectionImplClass = connectionImplClass;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public Element getManagedConnectionFactoryProperties() {
        return this.managedConnectionFactoryProperties;
    }

    public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties) {
        this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
    }

    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    public void setAuthenticationMechanismType(String authenticationMechanismType) {
        this.authenticationMechanismType = authenticationMechanismType;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void setCredentialInterface(String credentialInterface) {
        this.credentialInterface = credentialInterface;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public ManagedConnectionFactory getMcfInstance() {
        return this.mcf;
    }

    @Override
    protected void startService() throws Exception {
        if (this.mcf != null) {
            throw new DeploymentException("Stop the RARDeployment before restarting it");
        }
        ResourceAdapter resourceAdapter = null;
        ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
        try {
            resourceAdapter = (ResourceAdapter)this.getServer().getAttribute(this.oldRarDeployment, "ResourceAdapter");
            if (cdmd == null) {
                throw new DeploymentException("ConnectionDefinition '" + this.connectionDefinition + "' not found in rar '" + this.rarName + "'");
            }
            this.setManagedConnectionFactoryClass(cdmd.getManagedConnectionFactoryClass());
            this.setReauthenticationSupport(this.cmd.getReauthenticationSupport());
        }
        catch (Exception e) {
            throw new DeploymentException("couldn't get oldRarDeployment! " + this.oldRarDeployment, e);
        }
        try {
            this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(cdmd.getManagedConnectionFactoryClass());
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass, cnfe);
            throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
        }
        try {
            this.mcf = (ManagedConnectionFactory)this.mcfClass.newInstance();
        }
        catch (Exception e) {
            this.log.error("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass, e);
            throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
        }
        if (this.cmd != null) {
            this.setMcfProperties(this.cmd.getProperties(), false);
            this.setMcfProperties(cdmd.getProperties(), true);
        }
        this.setManagedConnectionFactoryProperties(this.dmd.getManagedConnectionFactoryProperties());
        if (resourceAdapter != null && this.mcf instanceof ResourceAdapterAssociation) {
            ResourceAdapterAssociation raa = (ResourceAdapterAssociation)((Object)this.mcf);
            raa.setResourceAdapter(resourceAdapter);
        }
    }

    @Override
    protected void stopService() {
        this.mcf = null;
        this.mcfClass = null;
        this.cmd = null;
        this.dmd = null;
    }

    public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value) {
        this.setManagedConnectionFactoryAttribute(name, clazz, value, false);
    }

    protected void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value, boolean mustExist) {
        Method setter;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + name);
        }
        String setterName = "set" + Character.toUpperCase(name.charAt(0));
        if (name.length() > 1) {
            setterName = setterName.concat(name.substring(1));
        }
        try {
            setter = this.mcfClass.getMethod(setterName, clazz);
        }
        catch (NoSuchMethodException nsme) {
            String error = "The class '" + this.mcfClass.toString() + "' has no setter for config property '" + name + "'";
            if (mustExist) {
                throw new IllegalArgumentException(error);
            }
            this.log.trace(error, nsme);
            return;
        }
        try {
            setter.invoke((Object)this.mcf, value);
            this.log.debug("set property " + name + " to value " + value);
        }
        catch (Exception e) {
            String error = "Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'";
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, e);
        }
        this.sendNotification(new Notification(MCF_ATTRIBUTE_CHANGED_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
    }

    public Object getManagedConnectionFactoryAttribute(String name) {
        Method getter;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + name);
        }
        String getterName = "get" + Character.toUpperCase(name.charAt(0));
        if (name.length() > 1) {
            getterName = getterName.concat(name.substring(1));
        }
        try {
            getter = this.mcfClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "The class '" + this.mcfClass + "' has no getter(" + getterName + ") for config property '" + name + "'";
            this.log.debug(msg, e);
            throw new IllegalArgumentException(msg);
        }
        try {
            Object value = getter.invoke((Object)this.mcf, new Object[0]);
            this.log.debug("get property " + name + ": value " + value);
            return value;
        }
        catch (Exception e) {
            String error = "Unable to invoke getter method '" + getter + "' " + "on object '" + this.mcf + "'";
            this.log.debug(error, e);
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, e);
        }
    }

    protected void setMcfProperties(Collection properties, boolean mustExist) throws DeploymentException {
        for (ConfigPropertyMetaData cpmd : properties) {
            PropertyEditor pe;
            String name = cpmd.getName();
            String type = cpmd.getType();
            String value = cpmd.getValue();
            if (name == null || name.length() == 0 || value == null || value.length() == 0) {
                this.log.debug("Not setting config property '" + name + "'");
                continue;
            }
            Class<?> clazz = Classes.getPrimitiveTypeForName(type);
            if (clazz == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
                    continue;
                }
            }
            if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
                continue;
            }
            value = StringPropertyReplacer.replaceProperties(value);
            this.log.debug("setting property: " + name + " to value " + value);
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
                continue;
            }
            Object v = pe.getValue();
            this.setManagedConnectionFactoryAttribute(name, clazz, v, mustExist);
        }
    }

    protected void setManagedConnectionFactoryProperties(List<ManagedConnectionFactoryPropertyMetaData> properties) {
        for (ManagedConnectionFactoryPropertyMetaData property : properties) {
            PropertyEditor pe;
            Class<?> clazz;
            String name = property.getName();
            String type = property.getType();
            String value = property.getValue();
            if (name == null || name.length() == 0 || value == null || value.length() == 0) {
                this.log.debug("Not setting config property '" + name + "'");
                continue;
            }
            if (type == null || type.length() == 0) {
                type = "java.lang.String";
            }
            if ((clazz = Classes.getPrimitiveTypeForName(type)) == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
                    continue;
                }
            }
            if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
                continue;
            }
            value = StringPropertyReplacer.replaceProperties(value);
            this.log.debug("setting property: " + name + " to value " + value);
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
                continue;
            }
            Object v = pe.getValue();
            this.setManagedConnectionFactoryAttribute(name, clazz, v);
        }
    }

    @Override
    public Object createConnectionFactory() throws ResourceException {
        return this.mcf.createConnectionFactory();
    }

    @Override
    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return this.mcf.createConnectionFactory(cxManager);
    }

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.createManagedConnection(subject, cxRequestInfo);
    }

    @Override
    public boolean equals(Object other) {
        return ((Object)this.mcf).equals(other);
    }

    @Override
    public PrintWriter getLogWriter() throws ResourceException {
        return this.mcf.getLogWriter();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.mcf).hashCode();
    }

    @Override
    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.matchManagedConnections(connectionSet, subject, cxRequestInfo);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.mcf.setLogWriter(out);
    }

    @Override
    protected MBeanAttributeInfo[] getInternalAttributeInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        attributes.add(new MBeanAttributeInfo("RARName", String.class.getName(), "The ResourceAdapter deployment name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("OldRarDeployment", ObjectName.class.getName(), "The Connection Defintion class name.", true, true, false));
        attributes.add(new MBeanAttributeInfo("ConnectionDefinition", String.class.getName(), "The Connection Defintion class name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("VendorName", String.class.getName(), "The Vendor Name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("SpecVersion", String.class.getName(), "The Specification Version.", true, false, false));
        attributes.add(new MBeanAttributeInfo("EisType", String.class.getName(), "The Enterprise Information System type.", true, false, false));
        attributes.add(new MBeanAttributeInfo("Version", String.class.getName(), "The ResourceAdapter version.", true, false, false));
        attributes.add(new MBeanAttributeInfo("ManagedConnectionFactoryClass", String.class.getName(), "The ManagedConnectionFactory class", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionFactoryImpl", String.class.getName(), "The Connection Factory implementation", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionInterface", String.class.getName(), "The Connection Inteface", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionImplClass", String.class.getName(), "The Connection Implementation class", true, false, false));
        attributes.add(new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The Transaction Support", true, false, false));
        attributes.add(new MBeanAttributeInfo("AuthenticationMechanismType", String.class.getName(), "The Authentication Mechanism Type", true, false, false));
        attributes.add(new MBeanAttributeInfo("CredentialInterface", String.class.getName(), "The Credential Interface", true, false, false));
        attributes.add(new MBeanAttributeInfo("ReauthenticationSupport", Boolean.class.getName(), "The Reauthentication Support", true, false, true));
        attributes.add(new MBeanAttributeInfo("McfInstance", "javax.resource.spi.ManagedConnectionFactory", "The ManagedConnectionFactory instance", true, false, false));
        ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.connectionDefinition);
        MBeanAttributeInfo[] info = attributes.toArray(new MBeanAttributeInfo[attributes.size()]);
        return info;
    }

    @Override
    protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if ("OldRarDeployment".equals(attribute.getName())) {
            this.oldRarDeployment = (ObjectName)attribute.getValue();
        }
    }

    @Override
    protected MBeanOperationInfo[] getInternalOperationInfo() {
        MBeanOperationInfo[] operations = new MBeanOperationInfo[1];
        MBeanParameterInfo[] getMCFAttributeParamInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("ManagedConnectionFactoryAttributeName", String.class.getName(), "The ManagedConnectionFactoryAttribute name")};
        operations[0] = new MBeanOperationInfo("getManagedConnectionFactoryAttribute", "Inspect the value of a ManagedConnectionFactory attribute", getMCFAttributeParamInfo, Object.class.getName(), 0);
        return operations;
    }

    @Override
    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("getManagedConnectionFactoryAttribute")) {
            String param = (String)params[0];
            return this.getManagedConnectionFactoryAttribute(param);
        }
        return super.internalInvoke(actionName, params, signature);
    }

    @Override
    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
        Object result = null;
        if ("RARName".equals(attribute)) {
            result = this.rarName;
        } else if ("OldRarDeployment".equals(attribute)) {
            result = this.oldRarDeployment;
        } else if ("ConnectionDefinition".equals(attribute)) {
            result = this.dmd.getConnectionDefinition();
        } else if ("VendorName".equals(attribute)) {
            result = this.cmd.getVendorName();
        } else if ("SpecVersion".equals(attribute)) {
            result = this.cmd.getVersion();
        } else if ("EisType".equals(attribute)) {
            result = this.cmd.getEISType();
        } else if ("Version".equals(attribute)) {
            result = this.cmd.getRAVersion();
        } else if ("ManagedConnectionFactoryClass".equals(attribute)) {
            result = cdmd.getManagedConnectionFactoryClass();
        } else if ("ConnectionInterface".equals(attribute)) {
            result = cdmd.getConnectionInterfaceClass();
        } else if ("ConnectionFactoryImpl".equals(attribute)) {
            result = cdmd.getConnectionFactoryImplementationClass();
        } else if ("ConnectionImplClass".equals(attribute)) {
            result = cdmd.getConnectionImplementationClass();
        } else if ("TransactionSupport".equals(attribute)) {
            result = this.dmd.getTransactionSupportMetaData();
        } else if ("AuthenticationMechanismType".equals(attribute)) {
            result = this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
        } else if ("CredentialInterface".equals(attribute)) {
            result = this.cmd.getAuthenticationMechanism().getCredentialInterfaceClass();
        } else if ("ReauthenticationSupport".equals(attribute)) {
            result = this.cmd.getReauthenticationSupport();
        } else if ("McfInstance".equals(attribute)) {
            result = this.mcf;
        }
        if (result == null) {
            result = super.getInternalAttribute(attribute);
        }
        return result;
    }

    @Override
    protected String getInternalDescription() {
        String description = null;
        DescriptionGroupMetaData dgmd = this.cmd.getDescription();
        if (dgmd != null) {
            description = dgmd.getDescription();
        }
        if (description == null) {
            description = "RAR Deployment ";
        }
        return description;
    }
}

