/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.resource.metadata.mcf.XAConnectionPropertyMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XADataSourceDeploymentMetaDataBuilder
extends AbstractManagedObjectFactory {
    private final Type mapType;
    private final Type mapOfMapsType;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public XADataSourceDeploymentMetaDataBuilder() {
        try {
            this.mapType = this.getClass().getMethod("compositeValueMap", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find compoditeValueMap method.");
        }
        try {
            this.mapOfMapsType = this.getClass().getMethod("mapOfMaps", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find mapOfMaps method.");
        }
    }

    @Override
    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, Serializable object) {
        if ("xa-datasource-properties".equals(property.getName())) {
            MetaValue metaValue = null;
            XADataSourceDeploymentMetaData ds = (XADataSourceDeploymentMetaData)object;
            List<XAConnectionPropertyMetaData> list2 = ds.getXADataSourceProperties();
            if (list2 != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (XAConnectionPropertyMetaData prop : list2) {
                    map.put(prop.getName(), prop.getValue());
                }
                metaValue = this.metaValueFactory.create(map, this.mapType);
            }
            return metaValue;
        }
        if ("config-property".equals(property.getName())) {
            MetaValue metaValue = null;
            ManagedConnectionFactoryDeploymentMetaData mcf = (ManagedConnectionFactoryDeploymentMetaData)object;
            List<ManagedConnectionFactoryPropertyMetaData> list3 = mcf.getManagedConnectionFactoryProperties();
            if (list3 != null) {
                HashMap map = new HashMap();
                for (ManagedConnectionFactoryPropertyMetaData prop : list3) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("name", prop.getName());
                    value.put("type", prop.getType());
                    value.put("value", prop.getValue());
                    map.put(value.get("name"), value);
                }
                metaValue = this.metaValueFactory.create(map, this.mapOfMapsType);
            }
            return metaValue;
        }
        return super.getValue(beanInfo, property, object);
    }

    @Override
    public void setValue(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value) {
        if ("xa-datasource-properties".equals(property.getName())) {
            String propName = this.getPropertyName(property);
            PropertyInfo propertyInfo = beanInfo.getProperty(propName);
            Map map = (Map)this.metaValueFactory.unwrap(value, this.mapType);
            ArrayList<XAConnectionPropertyMetaData> list2 = null;
            if (map != null) {
                list2 = new ArrayList<XAConnectionPropertyMetaData>();
                for (String name : map.keySet()) {
                    XAConnectionPropertyMetaData xaProp = new XAConnectionPropertyMetaData();
                    xaProp.setName(name);
                    xaProp.setValue((String)map.get(name));
                    list2.add(xaProp);
                }
            }
            try {
                propertyInfo.set(object, list2);
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        } else if ("config-property".equals(property.getName())) {
            String propName = this.getPropertyName(property);
            PropertyInfo propertyInfo = beanInfo.getProperty(propName);
            Map map = (Map)this.metaValueFactory.unwrap(value, this.mapOfMapsType);
            ArrayList<ManagedConnectionFactoryPropertyMetaData> list3 = null;
            if (map != null) {
                list3 = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
                for (Map entry : map.values()) {
                    ManagedConnectionFactoryPropertyMetaData prop = new ManagedConnectionFactoryPropertyMetaData();
                    prop.setName((String)entry.get("name"));
                    prop.setValue((String)entry.get("value"));
                    prop.setType((String)entry.get("type"));
                    list3.add(prop);
                }
            }
            try {
                propertyInfo.set(object, list3);
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        } else {
            super.setValue(beanInfo, property, object, value);
        }
    }

    public Map<String, String> compositeValueMap() {
        return null;
    }

    public Map<String, Map<String, String>> mapOfMaps() {
        return null;
    }
}

