/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityActions;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.SecurityContextAssociation;

public final class SecurityAssociation {
    private static Logger log = Logger.getLogger(SecurityAssociation.class);
    private static boolean trace;
    private static boolean server;
    private static Principal principal;
    private static Object credential;
    private static ThreadLocal threadPrincipal;
    private static ThreadLocal threadCredential;
    private static ThreadLocal threadContextMap;
    private static RunAsThreadLocalStack threadRunAsStacks;
    private static SubjectThreadLocalStack threadSubjectStacks;
    private static final RuntimePermission getPrincipalInfoPermission;
    private static final RuntimePermission getSubjectPermission;
    private static final RuntimePermission setPrincipalInfoPermission;
    private static final RuntimePermission setServerPermission;
    private static final RuntimePermission setRunAsIdentity;
    private static final RuntimePermission getContextInfo;
    private static final RuntimePermission setContextInfo;

    public static Principal getPrincipal() {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        Principal thePrincipal = principal;
        if (server) {
            thePrincipal = (Principal)threadPrincipal.get();
        }
        if (trace) {
            log.trace("getPrincipal, principal=" + thePrincipal);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            if (trace) {
                log.warn("You are using deprecated api to getPrincipal. Use security context based approach");
            }
            thePrincipal = sc.getUtil().getUserPrincipal();
        }
        return thePrincipal;
    }

    public static Principal getCallerPrincipal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        Principal thePrincipal = null;
        if (sc != null) {
            RunAs ras = sc.getIncomingRunAs();
            thePrincipal = ras != null ? new SimplePrincipal(ras.getName()) : sc.getUtil().getUserPrincipal();
        }
        if (trace) {
            log.trace("getCallerPrincipal, principal=" + thePrincipal);
        }
        return thePrincipal;
    }

    public static Object getCredential() {
        SecurityContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if ((sc = SecurityContextAssociation.getSecurityContext()) != null) {
            if (trace) {
                log.warn("You are using deprecated api to getCredential. Use security context based approach");
            }
            credential = sc.getUtil().getCredential();
        }
        return credential;
    }

    public static Subject getSubject() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getSubjectPermission);
        }
        SubjectContext sc = threadSubjectStacks.peek();
        if (trace) {
            log.trace("getSubject, sc=" + sc);
        }
        Subject subject = null;
        SecurityContext secContext = SecurityContextAssociation.getSecurityContext();
        if (secContext != null) {
            if (trace) {
                log.warn("You are using deprecated api to getSubject. Use security context based approach");
            }
            subject = secContext.getUtil().getSubject();
        }
        return subject;
    }

    public static void setPrincipal(Principal principal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("setPrincipal, p=" + principal + ", server=" + server);
        }
        SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
        if (!server && securityContext == null) {
            try {
                securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityContextAssociation.setSecurityContext(securityContext);
        }
        if (securityContext != null) {
            if (trace) {
                log.warn("Using deprecated API. Move to a security context based approach");
            }
            Object cred = securityContext.getUtil().getCredential();
            Subject subj = securityContext.getUtil().getSubject();
            securityContext.getUtil().createSubjectInfo(principal, cred, subj);
        }
    }

    public static void setCredential(Object credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
        if (!server && securityContext == null) {
            try {
                securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityContextAssociation.setSecurityContext(securityContext);
        }
        if (securityContext != null) {
            if (trace) {
                log.warn("Using deprecated API. Move to a security context based approach");
            }
            Principal principal = securityContext.getUtil().getUserPrincipal();
            Subject subj = securityContext.getUtil().getSubject();
            securityContext.getUtil().createSubjectInfo(principal, credential, subj);
        }
    }

    public static void setSubject(Subject subject) {
        SecurityContext sctx;
        SubjectContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("setSubject, s=" + subject + ", server=" + server);
        }
        if ((sc = threadSubjectStacks.peek()) == null) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        } else if ((sc.getFlags() & 1) != 0) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        }
        sc.setSubject(subject);
        if (trace) {
            log.trace("setSubject, sc=" + sc);
        }
        if ((sctx = SecurityContextAssociation.getSecurityContext()) != null) {
            SubjectInfo si = sctx.getSubjectInfo();
            if (si != null) {
                si.setAuthenticatedSubject(subject);
            } else {
                sctx.getUtil().createSubjectInfo(null, null, subject);
            }
        }
    }

    public static Object getContextInfo(Object key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getContextInfo);
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo != null ? contextInfo.get(key) : null;
    }

    public static Object setContextInfo(Object key, Object value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setContextInfo);
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo.put(key, value);
    }

    public static void pushSubjectContext(Subject subject, Principal principal, Object credential) {
        SecurityContext sctx;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadPrincipal.set(principal);
            threadCredential.set(credential);
        } else {
            SecurityAssociation.principal = principal;
            SecurityAssociation.credential = credential;
        }
        SubjectContext sc = new SubjectContext(subject, principal, credential);
        threadSubjectStacks.push(sc);
        if (trace) {
            log.trace("pushSubjectContext, subject=" + subject + ", sc=" + sc);
        }
        if ((sctx = SecurityContextAssociation.getSecurityContext()) == null) {
            if (trace) {
                log.trace("WARN::Deprecated usage of SecurityAssociation. Use SecurityContext");
            }
            try {
                sctx = SecurityContextFactory.createSecurityContext("FROM_SECURITY_ASSOCIATION");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        sctx.getUtil().createSubjectInfo(principal, credential, subject);
        SecurityContextAssociation.setSecurityContext(sctx);
    }

    public static void dupSubjectContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        SubjectContext sc = threadSubjectStacks.dup();
        if (trace) {
            log.trace("dupSubjectContext, sc=" + sc);
        }
    }

    public static SubjectContext popSubjectContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        SubjectContext sc = threadSubjectStacks.pop();
        if (trace) {
            log.trace("popSubjectContext, sc=" + sc);
        }
        Principal principal = null;
        Object credential = null;
        SubjectContext top = threadSubjectStacks.peek();
        if (top != null) {
            principal = top.getPrincipal();
            credential = top.getCredential();
        }
        if (server) {
            threadPrincipal.set(principal);
            threadCredential.set(credential);
        } else {
            SecurityAssociation.principal = principal;
            SecurityAssociation.credential = credential;
        }
        if (trace) {
            log.trace("WARN::Deprecated usage of SecurityAssociation. Use SecurityContext");
        }
        SecurityContext sctx = SecurityContextAssociation.getSecurityContext();
        if (sc == null && sctx != null) {
            SubjectInfo si = sctx.getSubjectInfo();
            sc = new SubjectContext(si.getAuthenticatedSubject(), si.getAuthenticationPrincipal(), si.getAuthenticationCredential());
        }
        if (sctx != null) {
            sctx.getSubjectInfo().setAuthenticatedSubject(null);
            sctx.getSubjectInfo().setAuthenticationPrincipal(null);
            sctx.getSubjectInfo().setAuthenticationCredential(null);
        }
        return sc;
    }

    public static SubjectContext peekSubjectContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        SubjectContext subjectCtx = null;
        if (sc != null) {
            SecurityContextUtil util = sc.getUtil();
            subjectCtx = new SubjectContext(util.getSubject(), util.getUserPrincipal(), util.getCredential());
        }
        return subjectCtx;
    }

    public static void clear() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("clear, server=" + server);
        }
        if (server) {
            threadPrincipal.set(null);
            threadCredential.set(null);
        } else {
            principal = null;
            credential = null;
        }
        threadSubjectStacks.clear();
        SecurityContextAssociation.clearSecurityContext();
    }

    public static void pushRunAsIdentity(RunAsIdentity runAs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        if (trace) {
            log.trace("pushRunAsIdentity, runAs=" + runAs);
        }
        threadRunAsStacks.push(runAs);
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            sc.setOutgoingRunAs(runAs);
        }
    }

    public static RunAsIdentity popRunAsIdentity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        RunAsIdentity ra = null;
        if (sc != null) {
            ra = (RunAsIdentity)sc.getOutgoingRunAs();
            sc.setOutgoingRunAs(null);
        }
        return ra;
    }

    public static RunAsIdentity peekRunAsIdentity() {
        RunAsIdentity ra = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            ra = (RunAsIdentity)sc.getOutgoingRunAs();
        }
        return ra;
    }

    public static RunAsIdentity peekRunAsIdentity(int depth) {
        RunAs ras;
        if (depth > 1) {
            throw new IllegalArgumentException("Security Context approach needs to be used. Depth upto 1");
        }
        if (depth == 0) {
            return SecurityAssociation.peekRunAsIdentity();
        }
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        RunAsIdentity ra = null;
        if (sc != null && (ras = sc.getIncomingRunAs()) instanceof RunAsIdentity) {
            ra = (RunAsIdentity)ras;
        }
        return ra;
    }

    public static boolean isServer() {
        return server;
    }

    public static void setServer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setServerPermission);
        }
        server = true;
    }

    static {
        getPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getPrincipalInfo");
        getSubjectPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getSubject");
        setPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setPrincipalInfo");
        setServerPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setServer");
        setRunAsIdentity = new RuntimePermission("org.jboss.security.SecurityAssociation.setRunAsRole");
        getContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "get");
        setContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "set");
        String flag = SecurityActions.getProperty("org.jboss.security.SecurityAssociation.ThreadLocal", "false");
        boolean useThreadLocal = Boolean.valueOf(flag);
        log.debug("Using ThreadLocal: " + useThreadLocal);
        trace = log.isTraceEnabled();
        if (useThreadLocal) {
            threadPrincipal = new ThreadLocal();
            threadCredential = new ThreadLocal();
            threadContextMap = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
        } else {
            threadPrincipal = new InheritableThreadLocal();
            threadCredential = new InheritableThreadLocal();
            threadContextMap = new HashMapInheritableLocal();
        }
        threadRunAsStacks = new RunAsThreadLocalStack(useThreadLocal);
        threadSubjectStacks = new SubjectThreadLocalStack(useThreadLocal);
    }

    private static class HashMapInheritableLocal
    extends InheritableThreadLocal {
        private HashMapInheritableLocal() {
        }

        protected Object childValue(Object parentValue) {
            HashMap map = (HashMap)parentValue;
            HashMap copy = null;
            try {
                copy = new HashMap(map);
            }
            catch (Throwable t) {
                log.debug("Failed to copy parent map, using new map");
                copy = new HashMap();
            }
            return copy;
        }

        protected Object initialValue() {
            return new HashMap();
        }
    }

    private static class ArrayListInheritableLocal
    extends InheritableThreadLocal {
        private ArrayListInheritableLocal() {
        }

        protected Object childValue(Object parentValue) {
            ArrayList list2 = (ArrayList)parentValue;
            ArrayList copy = null;
            try {
                copy = new ArrayList(list2);
            }
            catch (Throwable t) {
                log.debug("Failed to copy parent list, using new list");
                copy = new ArrayList();
            }
            return copy;
        }

        protected Object initialValue() {
            return new ArrayList();
        }
    }

    private static class ArrayListLocal
    extends ThreadLocal {
        private ArrayListLocal() {
        }

        protected Object initialValue() {
            return new ArrayList();
        }
    }

    private static class SubjectThreadLocalStack {
        ThreadLocal local;

        SubjectThreadLocalStack(boolean threadLocal) {
            this.local = threadLocal ? new ArrayListLocal() : new ArrayListInheritableLocal();
        }

        int size() {
            ArrayList stack = (ArrayList)this.local.get();
            return stack.size();
        }

        void push(SubjectContext context) {
            ArrayList stack = (ArrayList)this.local.get();
            stack.add(context);
        }

        SubjectContext dup() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.get(lastIndex);
                stack.add(context);
            }
            return context;
        }

        SubjectContext pop() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.remove(lastIndex);
            }
            return context;
        }

        SubjectContext peek() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.get(lastIndex);
            }
            return context;
        }

        void clear() {
            ArrayList stack = (ArrayList)this.local.get();
            stack.clear();
        }
    }

    public static class SubjectContext {
        public static final int SUBJECT_WAS_SET = 1;
        public static final int PRINCIPAL_WAS_SET = 2;
        public static final int CREDENTIAL_WAS_SET = 4;
        private Subject subject;
        private Principal principal;
        private Object credential;
        private int flags;

        public SubjectContext() {
            this.flags = 0;
        }

        public SubjectContext(Subject s, Principal p, Object cred) {
            this.subject = s;
            this.principal = p;
            this.credential = cred;
            this.flags = 7;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
            this.flags |= 1;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public void setPrincipal(Principal principal) {
            this.principal = principal;
            this.flags |= 2;
        }

        public Object getCredential() {
            return this.credential;
        }

        public void setCredential(Object credential) {
            this.credential = credential;
            this.flags |= 4;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append("{principal=");
            tmp.append(this.principal);
            tmp.append(",subject=");
            if (this.subject != null) {
                tmp.append(System.identityHashCode(this.subject));
            } else {
                tmp.append("null");
            }
            tmp.append("}");
            return tmp.toString();
        }
    }

    private static class RunAsThreadLocalStack {
        ThreadLocal local;

        RunAsThreadLocalStack(boolean threadLocal) {
            this.local = threadLocal ? new ArrayListLocal() : new ArrayListInheritableLocal();
        }

        int size() {
            ArrayList stack = (ArrayList)this.local.get();
            return stack.size();
        }

        void push(RunAsIdentity runAs) {
            ArrayList stack = (ArrayList)this.local.get();
            stack.add(runAs);
        }

        RunAsIdentity pop() {
            ArrayList stack = (ArrayList)this.local.get();
            RunAsIdentity runAs = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                runAs = (RunAsIdentity)stack.remove(lastIndex);
            }
            return runAs;
        }

        RunAsIdentity peek(int depth) {
            ArrayList stack = (ArrayList)this.local.get();
            RunAsIdentity runAs = null;
            int stackSize = stack.size();
            do {
                int index;
                if ((index = stackSize - 1 - depth) < 0) continue;
                runAs = (RunAsIdentity)stack.get(index);
            } while (runAs == null && ++depth <= stackSize - 1);
            return runAs;
        }
    }
}

