/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.cache;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.jboss.security.cache.SecurityCache;
import org.jboss.security.cache.SecurityCacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthenticationCache
implements SecurityCache<Principal> {
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private int concurrencyLevel = 16;
    private ConcurrentHashMap<Principal, AuthCacheObject> cacheMap = null;

    public JBossAuthenticationCache() {
        this.constructCache();
    }

    public JBossAuthenticationCache(int initCapacity, float loadFactor, int level) {
        this.concurrencyLevel = level;
        this.loadFactor = loadFactor;
        this.initialCapacity = initCapacity;
        this.constructCache();
    }

    @Override
    public void addCacheEntry(Principal principal, Map<String, Object> map) throws SecurityCacheException {
        try {
            AuthCacheObject ao = new AuthCacheObject(map.get("Credential"), (Subject)map.get("Subject"));
            this.cacheMap.put(principal, ao);
        }
        catch (Exception e) {
            throw new SecurityCacheException(e);
        }
    }

    @Override
    public boolean cacheHit(Principal principal) {
        return this.cacheMap.containsKey(principal);
    }

    @Override
    public void cacheOperation(Principal principal, Map<String, Object> map) throws SecurityCacheException {
        boolean isValid = false;
        if (!this.cacheHit(principal)) {
            throw new SecurityCacheException("Cache Miss");
        }
        Object cred = map.get("Credential");
        AuthCacheObject ao = this.cacheMap.get(principal);
        Object cacheCred = ao.credential;
        if (cred == null || cacheCred == null) {
            if (cred == null && cacheCred == null) {
                isValid = true;
            }
        } else if (cacheCred.getClass().isAssignableFrom(cred.getClass())) {
            if (cacheCred instanceof Comparable) {
                Comparable c = (Comparable)cacheCred;
                isValid = c.compareTo(cred) == 0;
            } else if (cacheCred instanceof char[]) {
                char[] a1 = (char[])cacheCred;
                char[] a2 = (char[])cred;
                isValid = Arrays.equals(a1, a2);
            } else if (cacheCred instanceof byte[]) {
                byte[] a1 = (byte[])cacheCred;
                byte[] a2 = (byte[])cred;
                isValid = Arrays.equals(a1, a2);
            } else if (cacheCred.getClass().isArray()) {
                Object[] a1 = (Object[])cacheCred;
                Object[] a2 = (Object[])cred;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = cacheCred.equals(cred);
            }
        } else if (cacheCred instanceof char[] && cred instanceof String) {
            char[] a1 = (char[])cacheCred;
            char[] a2 = ((String)cred).toCharArray();
            isValid = Arrays.equals(a1, a2);
        } else if (cacheCred instanceof String && cred instanceof char[]) {
            char[] a1 = ((String)cacheCred).toCharArray();
            char[] a2 = (char[])cred;
            isValid = Arrays.equals(a1, a2);
        }
        if (!isValid) {
            throw new SecurityCacheException("Cache Validation Failed");
        }
    }

    @Override
    public <Y> Y get(Principal key) throws SecurityCacheException {
        Subject subj = null;
        if (this.cacheHit(key)) {
            AuthCacheObject aco = this.cacheMap.get(key);
            subj = aco.subject;
        }
        return (Y)subj;
    }

    private void constructCache() {
        this.cacheMap = new ConcurrentHashMap(this.initialCapacity, this.loadFactor, this.concurrencyLevel);
    }

    private class AuthCacheObject {
        private Object credential;
        private Subject subject;

        public AuthCacheObject(Object credential, Subject subject) {
            this.credential = credential;
            this.subject = subject;
        }
    }
}

